/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.utils.AbstractParameterTool;
import org.apache.flink.api.java.utils.AbstractParameterToolTest;
import org.apache.flink.api.java.utils.ParameterTool;
import org.junit.Assert;
import org.junit.Test;

public class ParameterToolTest
extends AbstractParameterToolTest {
    @Test
    public void testFromCliArgs() {
        ParameterTool parameter = (ParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput", "-expectedCount", "15", "--withoutValues", "--negativeFloat", "-0.58", "-isWorking", "true", "--maxByte", "127", "-negativeShort", "-1024"});
        Assert.assertEquals((long)7L, (long)parameter.getNumberOfParameters());
        this.validate((AbstractParameterTool)parameter);
        Assert.assertTrue((boolean)parameter.has("withoutValues"));
        Assert.assertEquals((double)-0.58, (double)parameter.getFloat("negativeFloat"), (double)0.1);
        Assert.assertTrue((boolean)parameter.getBoolean("isWorking"));
        Assert.assertEquals((long)127L, (long)parameter.getByte("maxByte"));
        Assert.assertEquals((long)-1024L, (long)parameter.getShort("negativeShort"));
    }

    @Test
    public void testFromPropertiesFile() throws IOException {
        File propertiesFile = this.tmp.newFile();
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        try (FileOutputStream out = new FileOutputStream(propertiesFile);){
            props.store(out, "Test properties");
        }
        ParameterTool parameter = ParameterTool.fromPropertiesFile((String)propertiesFile.getAbsolutePath());
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate((AbstractParameterTool)parameter);
        parameter = ParameterTool.fromPropertiesFile((File)propertiesFile);
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate((AbstractParameterTool)parameter);
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            parameter = ParameterTool.fromPropertiesFile((InputStream)fis);
        }
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate((AbstractParameterTool)parameter);
    }

    @Test
    public void testFromMapOrProperties() {
        Properties props = new Properties();
        props.setProperty("input", "myInput");
        props.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromMap((Map)props);
        Assert.assertEquals((long)2L, (long)parameter.getNumberOfParameters());
        this.validate((AbstractParameterTool)parameter);
    }

    @Test
    public void testSystemProperties() {
        System.setProperty("input", "myInput");
        System.setProperty("expectedCount", "15");
        ParameterTool parameter = ParameterTool.fromSystemProperties();
        this.validate((AbstractParameterTool)parameter);
    }

    @Test
    public void testMerged() {
        ParameterTool parameter1 = (ParameterTool)this.createParameterToolFromArgs(new String[]{"--input", "myInput"});
        System.setProperty("expectedCount", "15");
        ParameterTool parameter2 = ParameterTool.fromSystemProperties();
        ParameterTool parameter = parameter1.mergeWith(parameter2);
        this.validate((AbstractParameterTool)parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentExecutionConfigSerialization() throws ExecutionException, InterruptedException {
        int numInputs = 10;
        ArrayList<String> input = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            input.add("--" + UUID.randomUUID());
            input.add(UUID.randomUUID().toString());
        }
        String[] args = input.toArray(new String[0]);
        ParameterTool parameterTool = (ParameterTool)this.createParameterToolFromArgs(args);
        int numThreads = 5;
        int numSerializations = 100;
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(100);
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        try {
            for (int i = 0; i < 100; ++i) {
                futures.add(CompletableFuture.runAsync(() -> {
                    try {
                        this.serializeDeserialize(parameterTool);
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }, executorService));
            }
            for (CompletableFuture completableFuture : futures) {
                completableFuture.get();
            }
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
    }

    private void serializeDeserialize(ParameterTool parameterTool) throws IOException, ClassNotFoundException {
        parameterTool.get(UUID.randomUUID().toString());
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(baos);){
            oos.writeObject(parameterTool);
            oos.close();
            baos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            ParameterTool parameterTool2 = (ParameterTool)ois.readObject();
        }
    }
}

