/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.utils.AbstractParameterTool;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractParameterToolTest {
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testThrowExceptionIfParameterIsNotPrefixed() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Error parsing arguments '[a]' on 'a'. Please prefix keys with -- or -.");
        this.createParameterToolFromArgs(new String[]{"a"});
    }

    @Test
    public void testNoVal() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-berlin"});
        Assert.assertEquals((long)1L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("berlin"));
    }

    @Test
    public void testNoValDouble() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"--berlin"});
        Assert.assertEquals((long)1L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("berlin"));
    }

    @Test
    public void testMultipleNoVal() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"--a", "--b", "--c", "--d", "--e", "--f"});
        Assert.assertEquals((long)6L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
        Assert.assertTrue((boolean)parameter.has("c"));
        Assert.assertTrue((boolean)parameter.has("d"));
        Assert.assertTrue((boolean)parameter.has("e"));
        Assert.assertTrue((boolean)parameter.has("f"));
    }

    @Test
    public void testMultipleNoValMixed() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"--a", "-b", "-c", "-d", "--e", "--f"});
        Assert.assertEquals((long)6L, (long)parameter.getNumberOfParameters());
        Assert.assertTrue((boolean)parameter.has("a"));
        Assert.assertTrue((boolean)parameter.has("b"));
        Assert.assertTrue((boolean)parameter.has("c"));
        Assert.assertTrue((boolean)parameter.has("d"));
        Assert.assertTrue((boolean)parameter.has("e"));
        Assert.assertTrue((boolean)parameter.has("f"));
    }

    @Test
    public void testEmptyVal() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The input [--a, -b, --] contains an empty argument");
        this.createParameterToolFromArgs(new String[]{"--a", "-b", "--"});
    }

    @Test
    public void testEmptyValShort() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("The input [--a, -b, -] contains an empty argument");
        this.createParameterToolFromArgs(new String[]{"--a", "-b", "-"});
    }

    @Test
    public void testUnrequestedBoolean() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean", "true"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedBooleanWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean", "true"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean", false));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean", false));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedBooleanWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        parameter.getBoolean("boolean");
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedByte() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-byte", "1"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("byte"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedByteWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-byte", "1"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("byte"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte", (byte)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte", (byte)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedByteWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-byte"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("byte"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getByte("byte");
    }

    @Test
    public void testUnrequestedShort() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-short", "2"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("short"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedShortWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-short", "2"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("short"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short", (short)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short", (short)0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedShortWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-short"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("short"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getShort("short");
    }

    @Test
    public void testUnrequestedInt() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-int", "4"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("int"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedIntWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-int", "4"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("int"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int", 0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int", 0));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedIntWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-int"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("int"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getInt("int");
    }

    @Test
    public void testUnrequestedLong() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-long", "8"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("long"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedLongWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-long", "8"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("long"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long", 0L));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long", 0L));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedLongWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-long"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("long"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getLong("long");
    }

    @Test
    public void testUnrequestedFloat() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-float", "4"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("float"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedFloatWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-float", "4"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("float"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float", 0.0f), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float", 0.0f), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedFloatWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-float"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("float"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getFloat("float");
    }

    @Test
    public void testUnrequestedDouble() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-double", "8"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("double"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double"), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedDoubleWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-double", "8"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("double"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double", 0.0), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double", 0.0), (double)1.0E-5);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedDoubleWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-double"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("double"), (Object)parameter.getUnrequestedParameters());
        this.exception.expect(RuntimeException.class);
        this.exception.expectMessage("For input string: \"__NO_VALUE_KEY\"");
        parameter.getDouble("double");
    }

    @Test
    public void testUnrequestedString() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-string", "\u221e"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedStringWithDefaultValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-string", "\u221e"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string", "0.0"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string", "0.0"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedStringWithMissingValue() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-string"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        parameter.get("string");
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedHas() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("boolean"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.has("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.has("boolean"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedRequired() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-required", "\u221e"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("required"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.getRequired("required"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.getRequired("required"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedMultiple() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[]{"-boolean", "true", "-byte", "1", "-short", "2", "-int", "4", "-long", "8", "-float", "4.0", "-double", "8.0", "-string", "\u221e"});
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("boolean", "byte", "short", "int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean"));
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("byte", "short", "int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)1L, (long)parameter.getByte("byte"));
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("short", "int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)2L, (long)parameter.getShort("short"));
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("int", "long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)4L, (long)parameter.getInt("int"));
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("long", "float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((long)8L, (long)parameter.getLong("long"));
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("float", "double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)4.0, (double)parameter.getFloat("float"), (double)1.0E-5);
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("double", "string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((double)8.0, (double)parameter.getDouble("double"), (double)1.0E-5);
        Assert.assertEquals(AbstractParameterToolTest.createHashSet("string"), (Object)parameter.getUnrequestedParameters());
        Assert.assertEquals((Object)"\u221e", (Object)parameter.get("string"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    @Test
    public void testUnrequestedUnknown() {
        AbstractParameterTool parameter = this.createParameterToolFromArgs(new String[0]);
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
        Assert.assertTrue((boolean)parameter.getBoolean("boolean", true));
        Assert.assertEquals((long)0L, (long)parameter.getByte("byte", (byte)0));
        Assert.assertEquals((long)0L, (long)parameter.getShort("short", (short)0));
        Assert.assertEquals((long)0L, (long)parameter.getInt("int", 0));
        Assert.assertEquals((long)0L, (long)parameter.getLong("long", 0L));
        Assert.assertEquals((double)0.0, (double)parameter.getFloat("float", 0.0f), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)parameter.getDouble("double", 0.0), (double)1.0E-5);
        Assert.assertEquals((Object)"0", (Object)parameter.get("string", "0"));
        Assert.assertEquals(Collections.emptySet(), (Object)parameter.getUnrequestedParameters());
    }

    protected AbstractParameterTool createParameterToolFromArgs(String[] args) {
        return ParameterTool.fromArgs((String[])args);
    }

    protected static <T> Set<T> createHashSet(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    protected void validate(AbstractParameterTool parameter) {
        ClosureCleaner.ensureSerializable((Object)parameter);
        this.internalValidate(parameter);
        try {
            byte[] b = InstantiationUtil.serializeObject((Object)parameter);
            AbstractParameterTool copy = (AbstractParameterTool)InstantiationUtil.deserializeObject((byte[])b, (ClassLoader)this.getClass().getClassLoader());
            this.internalValidate(copy);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void internalValidate(AbstractParameterTool parameter) {
        Assert.assertEquals((Object)"myInput", (Object)parameter.getRequired("input"));
        Assert.assertEquals((Object)"myDefaultValue", (Object)parameter.get("output", "myDefaultValue"));
        Assert.assertNull((Object)parameter.get("whatever"));
        Assert.assertEquals((long)15L, (long)parameter.getLong("expectedCount", -1L));
        Assert.assertTrue((boolean)parameter.getBoolean("thisIsUseful", true));
        Assert.assertEquals((long)42L, (long)parameter.getByte("myDefaultByte", (byte)42));
        Assert.assertEquals((long)42L, (long)parameter.getShort("myDefaultShort", (short)42));
        if (parameter instanceof ParameterTool) {
            ParameterTool parameterTool = (ParameterTool)parameter;
            Configuration config = parameterTool.getConfiguration();
            Assert.assertEquals((long)15L, (long)config.getLong("expectedCount", -1L));
            Properties props = parameterTool.getProperties();
            Assert.assertEquals((Object)"myInput", (Object)props.getProperty("input"));
            try {
                String pathToFile = this.tmp.newFile().getAbsolutePath();
                parameterTool.createPropertiesFile(pathToFile);
                Properties defaultProps = new Properties();
                try (FileInputStream fis = new FileInputStream(pathToFile);){
                    defaultProps.load(fis);
                }
                Assert.assertEquals((Object)"myDefaultValue", (Object)defaultProps.get("output"));
                Assert.assertEquals((Object)"-1", (Object)defaultProps.get("expectedCount"));
                Assert.assertTrue((boolean)defaultProps.containsKey("input"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (parameter instanceof MultipleParameterTool) {
            MultipleParameterTool multipleParameterTool = (MultipleParameterTool)parameter;
            List<String> multiValues = Arrays.asList("multiValue1", "multiValue2");
            Assert.assertEquals(multiValues, (Object)multipleParameterTool.getMultiParameter("multi"));
            Assert.assertEquals(multiValues, multipleParameterTool.toMultiMap().get("multi"));
            Assert.assertEquals((Object)"multiValue2", multipleParameterTool.toMap().get("multi"));
        }
    }
}

