/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TextInputFormatTest
extends TestLogger {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleRead() throws IOException {
        String first = "First line";
        String second = "Second line";
        File tempFile = File.createTempFile("TextInputFormatTest", "tmp", this.temporaryFolder.getRoot());
        tempFile.setWritable(true);
        try (PrintStream ps = new PrintStream(tempFile);){
            ps.println("First line");
            ps.println("Second line");
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
        Configuration parameters = new Configuration();
        inputFormat.configure(parameters);
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        MatcherAssert.assertThat((String)"expected at least one input split", (Object)splits.length, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        inputFormat.open(splits[0]);
        try {
            Assert.assertFalse((boolean)inputFormat.reachedEnd());
            String result = (String)inputFormat.nextRecord((Object)"");
            Assert.assertNotNull((String)"Expecting first record here", (Object)result);
            Assert.assertEquals((Object)"First line", (Object)result);
            Assert.assertFalse((boolean)inputFormat.reachedEnd());
            result = (String)inputFormat.nextRecord((Object)result);
            Assert.assertNotNull((String)"Expecting second record here", (Object)result);
            Assert.assertEquals((Object)"Second line", (Object)result);
            Assert.assertTrue((inputFormat.reachedEnd() || null == inputFormat.nextRecord((Object)result) ? 1 : 0) != 0);
        }
        finally {
            inputFormat.close();
        }
    }

    @Test
    public void testNestedFileRead() throws IOException {
        String[] dirs = new String[]{"first", "second"};
        ArrayList<String> expectedFiles = new ArrayList<String>();
        File parentDir = this.temporaryFolder.getRoot();
        for (String dir : dirs) {
            FileInputSplit[] tmpDir = this.temporaryFolder.newFolder(dir);
            File tempFile = File.createTempFile("TextInputFormatTest", ".tmp", (File)tmpDir);
            expectedFiles.add(new Path(tempFile.getAbsolutePath()).makeQualified(FileSystem.getLocalFileSystem()).toString());
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(parentDir.toURI()));
        inputFormat.setNestedFileEnumeration(true);
        inputFormat.setNumLineSamples(10);
        Configuration config = new Configuration();
        config.setBoolean("recursive.file.enumeration", false);
        config.setString("delimited-format.numSamples", "20");
        inputFormat.configure(config);
        Assert.assertTrue((boolean)inputFormat.getNestedFileEnumeration());
        Assert.assertEquals((long)10L, (long)inputFormat.getNumLineSamples());
        FileInputSplit[] splits = inputFormat.createInputSplits(expectedFiles.size());
        ArrayList<String> paths = new ArrayList<String>();
        for (FileInputSplit split : splits) {
            paths.add(split.getPath().toString());
        }
        Collections.sort(expectedFiles);
        Collections.sort(paths);
        for (int i = 0; i < expectedFiles.size(); ++i) {
            Assert.assertEquals(expectedFiles.get(i), paths.get(i));
        }
    }

    @Test
    public void testRemovingTrailingCR() throws IOException {
        this.testRemovingTrailingCR("\n", "\n");
        this.testRemovingTrailingCR("\r\n", "\n");
        this.testRemovingTrailingCR("|", "|");
        this.testRemovingTrailingCR("|", "\n");
    }

    private void testRemovingTrailingCR(String lineBreaker, String delimiter) throws IOException {
        String first = "First line";
        String second = "Second line";
        String content = first + lineBreaker + second + lineBreaker;
        File tempFile = File.createTempFile("TextInputFormatTest", "tmp", this.temporaryFolder.getRoot());
        tempFile.setWritable(true);
        try (OutputStreamWriter wrt = new OutputStreamWriter(new FileOutputStream(tempFile));){
            wrt.write(content);
        }
        TextInputFormat inputFormat = new TextInputFormat(new Path(tempFile.toURI().toString()));
        inputFormat.setFilePath(tempFile.toURI().toString());
        Configuration parameters = new Configuration();
        inputFormat.configure(parameters);
        inputFormat.setDelimiter(delimiter);
        FileInputSplit[] splits = inputFormat.createInputSplits(1);
        inputFormat.open(splits[0]);
        if (delimiter.equals("\n") && (lineBreaker.equals("\n") || lineBreaker.equals("\r\n")) || lineBreaker.equals(delimiter)) {
            String result = (String)inputFormat.nextRecord((Object)"");
            Assert.assertNotNull((String)"Expecting first record here", (Object)result);
            Assert.assertEquals((Object)first, (Object)result);
            result = (String)inputFormat.nextRecord((Object)result);
            Assert.assertNotNull((String)"Expecting second record here", (Object)result);
            Assert.assertEquals((Object)second, (Object)result);
            result = (String)inputFormat.nextRecord((Object)result);
            Assert.assertNull((String)"The input file is over", (Object)result);
        } else {
            String result = (String)inputFormat.nextRecord((Object)"");
            Assert.assertNotNull((String)"Expecting first record here", (Object)result);
            Assert.assertEquals((Object)content, (Object)result);
        }
    }
}

