/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.mqtt;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.qcloud.iot_explorer.common.Status;
import com.qcloud.iot_explorer.mqtt.TXAlarmPingSender;
import com.qcloud.iot_explorer.mqtt.TXMqttActionCallBack;
import com.qcloud.iot_explorer.mqtt.TXMqttConstants;
import com.qcloud.iot_explorer.mqtt.TXOTACallBack;
import com.qcloud.iot_explorer.mqtt.TXOTAConstansts;
import com.qcloud.iot_explorer.mqtt.TXOTAImpl;
import com.qcloud.iot_explorer.utils.HmacSha256;
import com.qcloud.iot_explorer.utils.TXLog;
import java.util.HashMap;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSuback;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class TXMqttConnection
implements MqttCallbackExtended {
    public static final String TAG = "TXMQTT_1.3.0";
    public String mServerURI;
    public String mClientId;
    public String mProductId;
    public String mDeviceName;
    public String mUserName;
    public String mSecretKey;
    protected Context mContext;
    protected MqttClientPersistence mMqttPersist = null;
    protected MqttConnectOptions mConnOptions = null;
    protected MqttAsyncClient mMqttClient = null;
    protected TXAlarmPingSender mPingSender = null;
    protected TXMqttActionCallBack mActionCallBack = null;
    private HashMap<String, Integer> mSubscribedTopicMap = new HashMap();
    private static int INVALID_MESSAGE_ID = -1;
    protected int mLastReceivedMessageId = INVALID_MESSAGE_ID;
    private TXOTAImpl mOTAImpl = null;
    protected DisconnectedBufferOptions bufferOpts = null;
    protected volatile TXMqttConstants.ConnectStatus mConnectStatus = TXMqttConstants.ConnectStatus.kConnectIdle;

    public TXMqttConnection(Context context, String productID, String deviceName, String secretKey, TXMqttActionCallBack callBack) {
        this(context, productID, deviceName, secretKey, null, callBack);
    }

    public TXMqttConnection(Context context, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, TXMqttActionCallBack callBack) {
        this(context, productID, deviceName, secretKey, bufferOpts, null, callBack);
    }

    public TXMqttConnection(Context context, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack) {
        this(context, "ssl://iotcloud.tencentdevices.com:8883", productID, deviceName, secretKey, bufferOpts, clientPersistence, callBack);
    }

    public TXMqttConnection(Context context, String serverURI, String productID, String deviceName, String secretKey, DisconnectedBufferOptions bufferOpts, MqttClientPersistence clientPersistence, TXMqttActionCallBack callBack) {
        this.mContext = context;
        this.mSecretKey = secretKey;
        this.mServerURI = serverURI;
        this.mProductId = productID;
        this.mClientId = productID + deviceName;
        this.mDeviceName = deviceName;
        this.mUserName = this.mClientId + ";" + "12020126";
        this.bufferOpts = bufferOpts;
        this.mMqttPersist = clientPersistence;
        this.mActionCallBack = callBack;
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.bufferOpts = bufferOpts;
        this.mMqttClient.setBufferOpts(bufferOpts);
    }

    public synchronized Status connect(MqttConnectOptions options, Object userContext) {
        if (this.mConnectStatus.equals((Object)TXMqttConstants.ConnectStatus.kConnecting)) {
            TXLog.i(TAG, "The client is connecting. Connect return directly.");
            return Status.MQTT_CONNECT_IN_PROGRESS;
        }
        if (this.mConnectStatus.equals((Object)TXMqttConstants.ConnectStatus.kConnected)) {
            TXLog.i(TAG, "The client is already connected. Connect return directly.");
            return Status.OK;
        }
        this.mConnOptions = options;
        if (this.mConnOptions == null) {
            TXLog.e(TAG, "Connect options == null, will not connect.");
            return Status.PARAMETER_INVALID;
        }
        Long timestamp = options.isAutomaticReconnect() ? Long.valueOf(Integer.MAX_VALUE) : Long.valueOf(System.currentTimeMillis() / 1000L + 600L);
        String userNameStr = this.mUserName + ";" + this.getConnectId() + ";" + timestamp;
        this.mConnOptions.setUserName(userNameStr);
        if (this.mSecretKey != null && this.mSecretKey.length() != 0) {
            try {
                Log.d((String)TAG, (String)("secret is " + this.mSecretKey));
                String passWordStr = HmacSha256.getSignature(userNameStr.getBytes(), Base64.decode((String)this.mSecretKey, (int)0)) + ";hmacsha256";
                this.mConnOptions.setPassword(passWordStr.toCharArray());
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"Failed to set password");
            }
        }
        this.mConnOptions.setMqttVersion(4);
        IMqttActionListener mActionListener = new IMqttActionListener(){

            public void onSuccess(IMqttToken token) {
                TXLog.i(TXMqttConnection.TAG, "onSuccess!");
                TXMqttConnection.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnected);
                TXMqttConnection.this.mActionCallBack.onConnectCompleted(Status.OK, false, token.getUserContext(), "connected to " + TXMqttConnection.this.mServerURI);
            }

            public void onFailure(IMqttToken token, Throwable exception) {
                TXLog.e(TXMqttConnection.TAG, exception, "onFailure!", new Object[0]);
                TXMqttConnection.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                TXMqttConnection.this.mActionCallBack.onConnectCompleted(Status.ERROR, false, token.getUserContext(), exception.toString());
            }
        };
        if (this.mMqttClient == null) {
            try {
                this.mPingSender = new TXAlarmPingSender(this.mContext);
                this.mMqttClient = new MqttAsyncClient(this.mServerURI, this.mClientId, this.mMqttPersist, (MqttPingSender)this.mPingSender);
                this.mMqttClient.setCallback((MqttCallback)this);
                this.mMqttClient.setBufferOpts(this.bufferOpts);
                this.mMqttClient.setManualAcks(false);
            }
            catch (Exception e) {
                TXLog.e(TAG, "new MqttClient failed", e);
                this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                return Status.ERROR;
            }
        }
        try {
            TXLog.i(TAG, "Start connecting to %s", this.mServerURI);
            this.setConnectingState(TXMqttConstants.ConnectStatus.kConnecting);
            this.mMqttClient.connect(this.mConnOptions, userContext, mActionListener);
        }
        catch (Exception e) {
            TXLog.e(TAG, "MqttClient connect failed", e);
            this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
            return Status.ERROR;
        }
        return Status.OK;
    }

    public synchronized Status reconnect() {
        if (this.mMqttClient == null) {
            TXLog.e(TAG, "Reconnect myClient = null. Will not do reconnect");
            return Status.MQTT_NO_CONN;
        }
        if (this.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kConnecting)) {
            TXLog.i(TAG, "The client is connecting. Reconnect return directly.");
            return Status.MQTT_CONNECT_IN_PROGRESS;
        }
        if (this.mConnOptions.isAutomaticReconnect() && !this.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kConnecting)) {
            TXLog.i(TAG, "Requesting Automatic reconnect using New Java AC");
            try {
                this.mMqttClient.reconnect();
            }
            catch (Exception ex) {
                TXLog.e(TAG, "Exception occurred attempting to reconnect: ", ex);
                this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                return Status.ERROR;
            }
        }
        if (this.getConnectStatus().equals((Object)TXMqttConstants.ConnectStatus.kDisconnected) && !this.mConnOptions.isCleanSession()) {
            IMqttActionListener listener = new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    TXLog.i(TXMqttConnection.TAG, "onSuccess!");
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    TXLog.e(TXMqttConnection.TAG, exception, "onFailure!", new Object[0]);
                    TXMqttConnection.this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                    TXMqttConnection.this.mActionCallBack.onConnectCompleted(Status.ERROR, true, asyncActionToken.getUserContext(), exception.toString());
                }
            };
            try {
                this.mMqttClient.connect(this.mConnOptions, null, listener);
                this.setConnectingState(TXMqttConstants.ConnectStatus.kDisconnected);
            }
            catch (Exception e) {
                TXLog.e(TAG, "Exception occurred attempting to reconnect: ", e);
                this.setConnectingState(TXMqttConstants.ConnectStatus.kConnectFailed);
                return Status.ERROR;
            }
        }
        return Status.OK;
    }

    public Status disConnect(Object userContext) {
        return this.disConnect(0L, userContext);
    }

    public Status disConnect(long timeout, Object userContext) {
        this.mLastReceivedMessageId = INVALID_MESSAGE_ID;
        if (this.mOTAImpl != null) {
            this.mOTAImpl.setSubscribedState(false);
        }
        if (this.mMqttClient != null && this.mMqttClient.isConnected()) {
            IMqttActionListener mActionListener = new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    TXMqttConnection.this.setConnectingState(TXMqttConstants.ConnectStatus.kDisconnected);
                    TXMqttConnection.this.mActionCallBack.onDisconnectCompleted(Status.OK, asyncActionToken.getUserContext(), "disconnected to " + TXMqttConnection.this.mServerURI);
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable cause) {
                    TXMqttConnection.this.mActionCallBack.onDisconnectCompleted(Status.ERROR, asyncActionToken.getUserContext(), cause.toString());
                }
            };
            try {
                if (timeout <= 0L) {
                    this.mMqttClient.disconnect(userContext, mActionListener);
                } else {
                    this.mMqttClient.disconnect(timeout, userContext, mActionListener);
                }
            }
            catch (MqttException e) {
                TXLog.e(TAG, e, "manual disconnect failed.", new Object[0]);
                return Status.ERROR;
            }
        }
        return Status.ERROR;
    }

    public Status publish(String topic, MqttMessage message, Object userContext) {
        IMqttDeliveryToken sendToken = null;
        if (topic == null || topic.trim().length() == 0) {
            TXLog.e(TAG, "Topic is empty!!!");
            return Status.PARAMETER_INVALID;
        }
        if (topic.length() > 128) {
            TXLog.e(TAG, "Topic length is too long!!!");
            return Status.PARAMETER_INVALID;
        }
        TXLog.i(TAG, "Starting publish topic: %s Message: %s", topic, message.toString());
        if (this.mMqttClient != null && this.mMqttClient.isConnected()) {
            try {
                sendToken = this.mMqttClient.publish(topic, message, userContext, (IMqttActionListener)new QcloudMqttActionListener(0));
            }
            catch (Exception e) {
                TXLog.e(TAG, e, "publish topic: %s failed.", topic);
                return Status.ERROR;
            }
        } else if (this.mMqttClient != null && this.bufferOpts != null && this.bufferOpts.isBufferEnabled()) {
            try {
                sendToken = this.mMqttClient.publish(topic, message, userContext, (IMqttActionListener)new QcloudMqttActionListener(0));
            }
            catch (Exception e) {
                TXLog.e(TAG, e, "publish topic: %s failed.", topic);
                return Status.ERROR;
            }
        } else {
            TXLog.e(TAG, "publish topic: %s failed, mMqttClient not connected and disconnect buffer not enough.", topic);
            return Status.ERROR;
        }
        return Status.OK;
    }

    public Status subscribe(String topic, int qos, Object userContext) {
        if (topic == null || topic.trim().length() == 0) {
            TXLog.e(TAG, "Topic is empty!!!");
            return Status.PARAMETER_INVALID;
        }
        if (topic.length() > 128) {
            TXLog.e(TAG, "Topic length is too long!!!");
            return Status.PARAMETER_INVALID;
        }
        TXLog.i(TAG, "Starting subscribe topic: %s", topic);
        if (this.mMqttClient != null && this.mMqttClient.isConnected()) {
            try {
                this.mMqttClient.subscribe(topic, qos, userContext, (IMqttActionListener)new QcloudMqttActionListener(1));
            }
            catch (Exception e) {
                TXLog.e(TAG, e, "subscribe topic: %s failed.", topic);
                return Status.ERROR;
            }
        } else {
            TXLog.e(TAG, "subscribe topic: %s failed, because mMqttClient not connected.", topic);
            return Status.MQTT_NO_CONN;
        }
        this.mSubscribedTopicMap.put(topic, qos);
        return Status.OK;
    }

    public Status unSubscribe(String topic, Object userContext) {
        if (topic == null || topic.trim().length() == 0) {
            TXLog.e(TAG, "Topic is empty!!!");
            return Status.PARAMETER_INVALID;
        }
        if (topic.length() > 128) {
            TXLog.e(TAG, "Topic length is too long!!!");
            return Status.PARAMETER_INVALID;
        }
        TXLog.i(TAG, "Starting unSubscribe topic: %s", topic);
        if (this.mMqttClient != null && this.mMqttClient.isConnected()) {
            try {
                this.mMqttClient.unsubscribe(topic, userContext, (IMqttActionListener)new QcloudMqttActionListener(2));
            }
            catch (Exception e) {
                TXLog.e(TAG, e, "unSubscribe topic: %s failed.", topic);
                return Status.ERROR;
            }
        } else {
            TXLog.e(TAG, "unSubscribe topic: %s failed, because mMqttClient not connected.", topic);
            return Status.MQTT_NO_CONN;
        }
        this.mSubscribedTopicMap.remove(topic);
        return Status.OK;
    }

    public void initOTA(String storagePath, TXOTACallBack callback) {
        this.mOTAImpl = new TXOTAImpl(this, storagePath, callback);
    }

    public Status reportCurrentFirmwareVersion(String currentFirmwareVersion) {
        if (this.mOTAImpl != null && currentFirmwareVersion != null) {
            return this.mOTAImpl.reportCurrentFirmwareVersion(currentFirmwareVersion);
        }
        return Status.ERROR;
    }

    public Status reportOTAState(TXOTAConstansts.ReportState state, int resultCode, String resultMsg, String version) {
        if (this.mOTAImpl != null) {
            return this.mOTAImpl.reportUpdateFirmwareState(state.toString().toLowerCase(), resultCode, resultMsg, version);
        }
        return Status.ERROR;
    }

    protected synchronized void setConnectingState(TXMqttConstants.ConnectStatus connectStatus) {
        this.mConnectStatus = connectStatus;
    }

    public TXMqttConstants.ConnectStatus getConnectStatus() {
        return this.mConnectStatus;
    }

    public void connectComplete(boolean reconnect, String serverURI) {
        TXLog.i(TAG, "connectComplete. reconnect flag is " + reconnect);
        this.setConnectingState(TXMqttConstants.ConnectStatus.kConnected);
        if (!reconnect) {
            return;
        }
        for (String topic : this.mSubscribedTopicMap.keySet()) {
            Integer qos = this.mSubscribedTopicMap.get(topic);
            try {
                TXLog.i(TAG, "subscribe to %s...", topic);
                this.mMqttClient.subscribe(topic, qos.intValue(), null, (IMqttActionListener)new QcloudMqttActionListener(1));
            }
            catch (Exception e) {
                TXLog.e(TAG, "subscribe to %s failed.", topic);
            }
        }
        this.mActionCallBack.onConnectCompleted(Status.OK, reconnect, null, "connected to " + serverURI);
    }

    public void connectionLost(Throwable cause) {
        TXLog.e(TAG, "connection lost because of: %s", cause.toString());
        this.setConnectingState(TXMqttConstants.ConnectStatus.kDisconnected);
        this.mActionCallBack.onConnectionLost(cause);
        this.mLastReceivedMessageId = INVALID_MESSAGE_ID;
        if (this.mOTAImpl != null) {
            this.mOTAImpl.setSubscribedState(false);
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        if (message.getQos() > 0 && message.getId() == this.mLastReceivedMessageId) {
            TXLog.e(TAG, "Received topic: %s, id: %d, message: %s, discard repeated message!!!", topic, message.getId(), message);
            return;
        }
        TXLog.i(TAG, "Received topic: %s, id: %d, message: %s", topic, message.getId(), message);
        this.mLastReceivedMessageId = message.getId();
        boolean consumed = false;
        if (this.mOTAImpl != null) {
            consumed = this.mOTAImpl.processMessage(topic, message);
        }
        if (this.mActionCallBack != null && !consumed) {
            this.mActionCallBack.onMessageReceived(topic, message);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken messageToken) {
        TXLog.i(TAG, "deliveryComplete, token.getMessageId:" + messageToken.getMessageId());
    }

    protected String getConnectId() {
        StringBuffer connectId = new StringBuffer();
        block5: for (int i = 0; i < 5; ++i) {
            int flag = (int)(Math.random() * 2.147483647E9) % 3;
            int randNum = (int)(Math.random() * 2.147483647E9);
            switch (flag) {
                case 0: {
                    connectId.append((char)(randNum % 26 + 97));
                    continue block5;
                }
                case 1: {
                    connectId.append((char)(randNum % 26 + 65));
                    continue block5;
                }
                case 2: {
                    connectId.append((char)(randNum % 10 + 48));
                }
            }
        }
        return connectId.toString();
    }

    private class QcloudMqttActionListener
    implements IMqttActionListener {
        private int command;

        public QcloudMqttActionListener(int command) {
            this.command = command;
        }

        public void onSuccess(IMqttToken token) {
            MqttWireMessage mqttWireMessage = token.getResponse();
            switch (this.command) {
                case 0: {
                    TXMqttConnection.this.mActionCallBack.onPublishCompleted(Status.OK, token, token.getUserContext(), "publish success");
                    break;
                }
                case 1: {
                    int[] qos = ((MqttSuback)mqttWireMessage).getGrantedQos();
                    if (null != qos && qos.length >= 1 && qos[0] == 128) {
                        TXMqttConnection.this.mActionCallBack.onSubscribeCompleted(Status.ERROR, token, token.getUserContext(), "subscribe fail");
                        break;
                    }
                    TXMqttConnection.this.mActionCallBack.onSubscribeCompleted(Status.OK, token, token.getUserContext(), "subscribe success");
                    if (TXMqttConnection.this.mOTAImpl == null) break;
                    TXMqttConnection.this.mOTAImpl.onSubscribeCompleted(Status.OK, token, token.getUserContext(), "subscribe success");
                    break;
                }
                case 2: {
                    TXMqttConnection.this.mActionCallBack.onUnSubscribeCompleted(Status.OK, token, token.getUserContext(), "unsubscribe success");
                    break;
                }
                default: {
                    TXLog.e(TXMqttConnection.TAG, "Unknown message on Success:" + token);
                }
            }
        }

        public void onFailure(IMqttToken token, Throwable exception) {
            switch (this.command) {
                case 0: {
                    TXMqttConnection.this.mActionCallBack.onPublishCompleted(Status.ERROR, token, token.getUserContext(), exception.toString());
                    break;
                }
                case 1: {
                    TXMqttConnection.this.mActionCallBack.onSubscribeCompleted(Status.ERROR, token, token.getUserContext(), exception.toString());
                    break;
                }
                case 2: {
                    TXMqttConnection.this.mActionCallBack.onUnSubscribeCompleted(Status.ERROR, token, token.getUserContext(), exception.toString());
                    break;
                }
                default: {
                    TXLog.e(TXMqttConnection.TAG, "Unknown message on onFailure:" + token);
                }
            }
        }
    }
}

