/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.iot_explorer.mqtt;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.qcloud.iot_explorer.utils.TXLog;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;

public class TXAlarmPingSender
implements MqttPingSender {
    public static final String TAG = "iot.TXAlarmPingSender";
    private ClientComms mComms;
    private Context mContext;
    private BroadcastReceiver mAlarmReceiver;
    private TXAlarmPingSender that;
    private PendingIntent pendingIntent;
    private volatile boolean hasStarted = false;

    public TXAlarmPingSender(Context context) {
        this.mContext = context;
        this.that = this;
    }

    public void init(ClientComms comms) {
        this.mComms = comms;
        this.mAlarmReceiver = new AlarmReceiver();
    }

    public void start() {
        String action = "iot.TXAlarmPingSender.pingSender." + this.mComms.getClient().getClientId();
        TXLog.d(TAG, "Register alarmreceiver to Context " + action);
        if (this.mContext != null && this.mAlarmReceiver != null) {
            this.mContext.registerReceiver(this.mAlarmReceiver, new IntentFilter(action));
        }
        this.pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(action), (int)0x8000000);
        this.schedule(this.mComms.getKeepAlive());
        this.hasStarted = true;
    }

    public void stop() {
        TXLog.d(TAG, "Unregister alarmreceiver to Context " + this.mComms.getClient().getClientId());
        if (this.hasStarted) {
            if (this.pendingIntent != null) {
                AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
                alarmManager.cancel(this.pendingIntent);
            }
            this.hasStarted = false;
            try {
                this.mContext.unregisterReceiver(this.mAlarmReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void schedule(long delayInMilliseconds) {
        long nextAlarmInMilliseconds = System.currentTimeMillis() + delayInMilliseconds;
        TXLog.d(TAG, "Schedule next alarm at " + nextAlarmInMilliseconds);
        AlarmManager alarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        if (Build.VERSION.SDK_INT >= 23) {
            TXLog.d(TAG, "Alarm scheule using setExactAndAllowWhileIdle, next: " + delayInMilliseconds);
            alarmManager.setExactAndAllowWhileIdle(0, nextAlarmInMilliseconds, this.pendingIntent);
        } else if (Build.VERSION.SDK_INT >= 19) {
            TXLog.d(TAG, "Alarm scheule using setExact, delay: " + delayInMilliseconds);
            alarmManager.setExact(0, nextAlarmInMilliseconds, this.pendingIntent);
        } else {
            alarmManager.set(0, nextAlarmInMilliseconds, this.pendingIntent);
        }
    }

    class AlarmReceiver
    extends BroadcastReceiver {
        private PowerManager.WakeLock wakelock;
        private final String wakeLockTag;

        AlarmReceiver() {
            this.wakeLockTag = "iot.TXAlarmPingSender.client." + TXAlarmPingSender.this.that.mComms.getClient().getClientId();
        }

        @SuppressLint(value={"Wakelock"})
        public void onReceive(Context context, Intent intent) {
            TXLog.d(TXAlarmPingSender.TAG, "Sending Ping at: " + System.currentTimeMillis());
            PowerManager pm = (PowerManager)TXAlarmPingSender.this.mContext.getSystemService("power");
            this.wakelock = pm.newWakeLock(1, this.wakeLockTag);
            this.wakelock.acquire();
            MqttToken token = TXAlarmPingSender.this.mComms.checkForActivity(new IMqttActionListener(){

                public void onSuccess(IMqttToken asyncActionToken) {
                    TXLog.d(TXAlarmPingSender.TAG, "Success. Release lock(" + AlarmReceiver.this.wakeLockTag + "):" + System.currentTimeMillis());
                    AlarmReceiver.this.wakelock.release();
                }

                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    TXLog.d(TXAlarmPingSender.TAG, "Failure. Release lock(" + AlarmReceiver.this.wakeLockTag + "):" + System.currentTimeMillis());
                    AlarmReceiver.this.wakelock.release();
                }
            });
            if (token == null && this.wakelock.isHeld()) {
                this.wakelock.release();
            }
        }
    }
}

