/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.SdkDigestInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class DigestValidationInputStream
extends SdkDigestInputStream {
    private byte[] expectedHash;
    private boolean digestValidated = false;

    public DigestValidationInputStream(InputStream in, MessageDigest digest, byte[] serverSideHash) {
        super(in, digest);
        this.expectedHash = serverSideHash;
    }

    @Override
    public int read() throws IOException {
        int ch = super.read();
        if (ch == -1) {
            this.validateDigest();
        }
        return ch;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result == -1) {
            this.validateDigest();
        }
        return result;
    }

    public byte[] getDigestChecksum() {
        return this.digest.digest();
    }

    private void validateDigest() {
        if (this.expectedHash != null && !this.digestValidated) {
            this.digestValidated = true;
            if (!Arrays.equals(this.digest.digest(), this.expectedHash)) {
                throw new CosClientException("Unable to verify integrity of data download.  Client calculated content hash didn't match hash calculated by Qcloud COS.  The data may be corrupt.");
            }
        }
    }
}

