/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.FileLockException;
import com.qcloud.cos.internal.FileLocks;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.transfer.DownloadImpl;
import com.qcloud.cos.transfer.DownloadMonitor;
import com.qcloud.cos.transfer.DownloadTaskImpl;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.utils.ServiceUtils;
import java.io.File;
import java.net.SocketException;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.SSLProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DownloadCallable
implements Callable<File> {
    private static final Logger log = LoggerFactory.getLogger(DownloadCallable.class);
    private final COS cos;
    private final CountDownLatch latch;
    private final GetObjectRequest req;
    private final boolean resumeExistingDownload;
    private final DownloadImpl download;
    private final File dstfile;
    private final long origStartingByte;
    private long expectedFileLength;
    private static boolean testing;

    DownloadCallable(COS cos, CountDownLatch latch, GetObjectRequest req, boolean resumeExistingDownload, DownloadImpl download, File dstfile, long origStartingByte, long expectedFileLength) {
        if (cos == null || latch == null || req == null || dstfile == null || download == null) {
            throw new IllegalArgumentException();
        }
        this.cos = cos;
        this.latch = latch;
        this.req = req;
        this.resumeExistingDownload = resumeExistingDownload;
        this.download = download;
        this.dstfile = dstfile;
        this.origStartingByte = origStartingByte;
        this.expectedFileLength = expectedFileLength;
    }

    @Override
    public File call() throws Exception {
        try {
            this.latch.await();
            this.download.setState(Transfer.TransferState.InProgress);
            COSObject cosObject = this.retryableDownloadCOSObjectToFile(this.dstfile, new DownloadTaskImpl(this.cos, this.download, this.req), this.resumeExistingDownload);
            if (cosObject == null) {
                this.download.setState(Transfer.TransferState.Canceled);
                this.download.setMonitor(new DownloadMonitor(this.download, null));
            } else {
                this.download.setState(Transfer.TransferState.Completed);
            }
            return this.dstfile;
        }
        catch (Throwable t) {
            if (this.download.getState() != Transfer.TransferState.Canceled) {
                this.download.setState(Transfer.TransferState.Failed);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustRequest(GetObjectRequest req) {
        long[] range = req.getRange();
        long lastByte = range[1];
        long totalBytesToDownload = lastByte - this.origStartingByte + 1L;
        if (this.dstfile.exists()) {
            if (!FileLocks.lock(this.dstfile)) {
                throw new FileLockException("Fail to lock " + this.dstfile + " for range adjustment");
            }
            try {
                this.expectedFileLength = this.dstfile.length();
                long startingByte = this.origStartingByte + this.expectedFileLength;
                log.info("Adjusting request range from " + Arrays.toString(range) + " to " + Arrays.toString(new long[]{startingByte, lastByte}) + " for file " + this.dstfile);
                req.setRange(startingByte, lastByte);
                totalBytesToDownload = lastByte - startingByte + 1L;
            }
            finally {
                FileLocks.unlock(this.dstfile);
            }
        }
        if (totalBytesToDownload < 0L) {
            throw new IllegalArgumentException("Unable to determine the range for download operation. lastByte=" + lastByte + ", origStartingByte=" + this.origStartingByte + ", expectedFileLength=" + this.expectedFileLength + ", totalBytesToDownload=" + totalBytesToDownload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSObject retryableDownloadCOSObjectToFile(File file, ServiceUtils.RetryableCOSDownloadTask retryableCOSDownloadTask, boolean appendData) {
        boolean hasRetried = false;
        while (true) {
            COSObject cosObject;
            if (this.resumeExistingDownload && hasRetried) {
                this.adjustRequest(this.req);
            }
            if ((cosObject = retryableCOSDownloadTask.getCOSObjectStream()) == null) {
                return null;
            }
            try {
                if (testing && this.resumeExistingDownload && !hasRetried) {
                    throw new CosClientException("testing");
                }
                ServiceUtils.downloadToFile(cosObject, file, retryableCOSDownloadTask.needIntegrityCheck(), appendData, this.expectedFileLength);
                COSObject cOSObject = cosObject;
                return cOSObject;
            }
            catch (CosClientException ace) {
                if (!ace.isRetryable()) {
                    throw ace;
                }
                if (ace.getCause() instanceof SocketException || ace.getCause() instanceof SSLProtocolException) {
                    throw ace;
                }
                if (hasRetried) {
                    throw ace;
                }
                log.info("Retry the download of object " + cosObject.getKey() + " (bucket " + cosObject.getBucketName() + ")", (Throwable)ace);
                hasRetried = true;
                continue;
            }
            finally {
                cosObject.getObjectContent().abort();
                continue;
            }
            break;
        }
    }

    static void setTesting(boolean b) {
        testing = b;
    }
}

