/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.http.CosHttpClient;
import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.http.CosHttpResponse;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpResponseHandler;
import com.qcloud.cos.http.IdleConnectionMonitorThread;
import com.qcloud.cos.internal.CosErrorResponseHandler;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.internal.CosServiceResponse;
import com.qcloud.cos.internal.ReleasableInputStream;
import com.qcloud.cos.internal.ResettableInputStream;
import com.qcloud.cos.internal.SdkBufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosHttpClient
implements CosHttpClient {
    private ClientConfig clientConfig;
    private RequestConfig requestConfig;
    private HttpClient httpClient;
    private PoolingHttpClientConnectionManager connectionManager;
    private IdleConnectionMonitorThread idleConnectionMonitor;
    private CosErrorResponseHandler errorResponseHandler = new CosErrorResponseHandler();
    private static final Logger log = LoggerFactory.getLogger(DefaultCosHttpClient.class);

    public DefaultCosHttpClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.connectionManager = new PoolingHttpClientConnectionManager();
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.connectionManager.setMaxTotal(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setDefaultMaxPerRoute(this.clientConfig.getMaxConnectionsCount());
        this.connectionManager.setValidateAfterInactivity(1);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionManager);
        if (this.clientConfig.getHttpProxyIp() != null && this.clientConfig.getHttpProxyPort() != 0) {
            HttpHost proxy = new HttpHost(this.clientConfig.getHttpProxyIp(), this.clientConfig.getHttpProxyPort());
            httpClientBuilder.setProxy(proxy);
        }
        this.httpClient = httpClientBuilder.build();
        this.requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.clientConfig.getConnectionRequestTimeout()).setConnectTimeout(this.clientConfig.getConnectionTimeout()).setSocketTimeout(this.clientConfig.getSocketTimeout()).build();
        this.idleConnectionMonitor = new IdleConnectionMonitorThread((HttpClientConnectionManager)this.connectionManager);
        this.idleConnectionMonitor.start();
    }

    @Override
    public void shutdown() {
        this.idleConnectionMonitor.shutdown();
    }

    private <X extends CosServiceRequest> HttpRequestBase buildHttpRequest(CosHttpRequest<X> request) throws CosClientException {
        HttpPut httpRequestBase = null;
        HttpMethodName httpMethodName = request.getHttpMethod();
        if (httpMethodName.equals((Object)HttpMethodName.PUT)) {
            httpRequestBase = new HttpPut();
        } else if (httpMethodName.equals((Object)HttpMethodName.GET)) {
            httpRequestBase = new HttpGet();
        } else if (httpMethodName.equals((Object)HttpMethodName.DELETE)) {
            httpRequestBase = new HttpDelete();
        } else if (httpMethodName.equals((Object)HttpMethodName.POST)) {
            httpRequestBase = new HttpPost();
        } else if (httpMethodName.equals((Object)HttpMethodName.HEAD)) {
            httpRequestBase = new HttpHead();
        }
        URIBuilder uriBuilder = new URIBuilder(request.getEndpoint());
        Map<String, String> requestParams = request.getParameters();
        for (Map.Entry<String, String> paramEntry : requestParams.entrySet()) {
            String paramKey = paramEntry.getKey();
            String paramValue = paramEntry.getValue();
            uriBuilder.addParameter(paramKey, paramValue);
        }
        Map<String, List<String>> customParamsList = ((CosServiceRequest)request.getOriginalRequest()).getCustomQueryParameters();
        if (customParamsList != null) {
            for (Map.Entry<String, List<String>> customParamsEntry : customParamsList.entrySet()) {
                String paramKey = customParamsEntry.getKey();
                List<String> paramValueList = customParamsEntry.getValue();
                int paramValueNum = paramValueList.size();
                for (int paramValueIndex = 0; paramValueIndex < paramValueNum; ++paramValueIndex) {
                    uriBuilder.addParameter(paramKey, paramValueList.get(paramValueIndex));
                }
            }
        }
        URI uri = null;
        try {
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new CosClientException("build uri error! CosHttpRequest: " + request.toString(), e);
        }
        httpRequestBase.setURI(uri);
        long content_length = -1L;
        Map<String, String> requestHeaders = request.getHeaders();
        for (Map.Entry<String, String> headerEntry : requestHeaders.entrySet()) {
            String headerKey = headerEntry.getKey();
            String headerValue = headerEntry.getValue();
            if (headerKey.equals("Content-Length")) {
                content_length = Long.parseLong(headerValue);
                continue;
            }
            httpRequestBase.addHeader(headerKey, headerValue);
        }
        Map<String, String> customRequestHeaders = ((CosServiceRequest)request.getOriginalRequest()).getCustomRequestHeaders();
        if (customRequestHeaders != null) {
            for (Map.Entry<String, String> customHeaderEntry : customRequestHeaders.entrySet()) {
                String headerKey = customHeaderEntry.getKey();
                String headerValue = customHeaderEntry.getValue();
                if (headerKey.equals("Content-Length")) {
                    content_length = Long.parseLong(headerValue);
                    continue;
                }
                httpRequestBase.addHeader(headerKey, headerValue);
            }
        }
        if (request.getContent() != null) {
            InputStreamEntity reqEntity = new InputStreamEntity(request.getContent(), content_length);
            if (httpMethodName.equals((Object)HttpMethodName.PUT) || httpMethodName.equals((Object)HttpMethodName.POST)) {
                HttpEntityEnclosingRequestBase entityRequestBase = (HttpEntityEnclosingRequestBase)httpRequestBase;
                entityRequestBase.setEntity((HttpEntity)reqEntity);
            }
        }
        httpRequestBase.setConfig(this.requestConfig);
        return httpRequestBase;
    }

    private boolean isRequestSuccessful(HttpResponse httpResponse) {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = -1;
        if (statusLine != null) {
            statusCode = statusLine.getStatusCode();
        }
        return statusCode / 100 == 2;
    }

    private <X extends CosServiceRequest> CosHttpResponse createResponse(HttpRequestBase httpRequestBase, CosHttpRequest<X> request, HttpResponse apacheHttpResponse) throws IOException {
        CosHttpResponse httpResponse = new CosHttpResponse(request, httpRequestBase);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private <X extends CosServiceRequest> CosServiceException handlerErrorMessage(CosHttpRequest<X> request, HttpRequestBase httpRequestBase, HttpResponse apacheHttpResponse) throws IOException {
        String reasonPhrase;
        int statusCode;
        StatusLine statusLine = apacheHttpResponse.getStatusLine();
        if (statusLine == null) {
            statusCode = -1;
            reasonPhrase = null;
        } else {
            statusCode = statusLine.getStatusCode();
            reasonPhrase = statusLine.getReasonPhrase();
        }
        CosHttpResponse response = this.createResponse(httpRequestBase, request, apacheHttpResponse);
        CosServiceException exception = null;
        try {
            exception = this.errorResponseHandler.handle(response);
            log.debug("Received error response: " + exception);
        }
        catch (Exception e) {
            if (statusCode == 413) {
                exception = new CosServiceException("Request entity too large");
                exception.setStatusCode(statusCode);
                exception.setErrorType(CosServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (statusCode == 503 && "Service Unavailable".equalsIgnoreCase(reasonPhrase)) {
                exception = new CosServiceException("Service unavailable");
                exception.setStatusCode(statusCode);
                exception.setErrorType(CosServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + "). Response Code: " + (statusLine == null ? "None" : Integer.valueOf(statusCode)) + ", Response Text: " + reasonPhrase;
            throw new CosClientException(errorMessage, e);
        }
        exception.setStatusCode(statusCode);
        exception.fillInStackTrace();
        return exception;
    }

    private <X extends CosServiceRequest> void bufferAndResetAbleContent(CosHttpRequest<X> request) {
        InputStream origContent = request.getContent();
        if (origContent != null) {
            InputStream toBeClosed = this.buffer(this.makeResettable(origContent));
            InputStream notCloseable = toBeClosed == null ? null : (InputStream)ReleasableInputStream.wrap(toBeClosed).disableClose();
            request.setContent(notCloseable);
        }
    }

    @Override
    public <X, Y extends CosServiceRequest> X exeute(CosHttpRequest<Y> request, HttpResponseHandler<CosServiceResponse<X>> responseHandler) throws CosClientException, CosServiceException {
        Object cse;
        HttpResponse httpResponse = null;
        HttpRequestBase httpRequest = null;
        int retryIndex = 0;
        int kMaxRetryCnt = 5;
        this.bufferAndResetAbleContent(request);
        InputStream originalContent = request.getContent();
        if (originalContent != null && originalContent.markSupported()) {
            int readLimit = this.clientConfig.getReadLimit();
            originalContent.mark(readLimit);
        }
        while (retryIndex < kMaxRetryCnt) {
            try {
                this.checkInterrupted();
                if (retryIndex != 0 && originalContent != null) {
                    originalContent.reset();
                }
                HttpClientContext context = HttpClientContext.create();
                httpRequest = this.buildHttpRequest(request);
                httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)context);
                break;
            }
            catch (IOException e) {
                httpRequest.abort();
                if (++retryIndex >= kMaxRetryCnt) {
                    String errMsg = String.format("httpClient execute occur a IOexcepiton. httpRequest: %s, excep: %s", request.toString(), e);
                    log.error(errMsg);
                    throw new CosClientException(errMsg);
                }
                String warnMsg = String.format("httpClient execute occur a IOexcepiton, ready to retry[%d/%d]. httpRequest: %s, excep: %s", retryIndex, kMaxRetryCnt, request.toString(), e);
                log.warn(warnMsg);
                int threadSleepMs = ThreadLocalRandom.current().nextInt(10, 100);
                try {
                    Thread.sleep(threadSleepMs);
                }
                catch (InterruptedException e1) {
                    throw new CosClientException("operation has been interrupted!");
                }
            }
        }
        if (!this.isRequestSuccessful(httpResponse)) {
            try {
                try {
                    throw this.handlerErrorMessage(request, httpRequest, httpResponse);
                }
                catch (IOException ioe) {
                    log.info("Unable to execute HTTP request: " + ioe.getMessage(), (Throwable)ioe);
                    cse = new CosServiceException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                    throw cse;
                }
            }
            catch (Throwable throwable) {
                httpRequest.abort();
                throw throwable;
            }
        }
        try {
            CosHttpResponse cosHttpResponse = this.createResponse(httpRequest, request, httpResponse);
            cse = responseHandler.handle(cosHttpResponse).getResult();
            return cse;
        }
        catch (Exception e) {
            log.info("Unable to execute Response handle: " + e.getMessage(), (Throwable)e);
            CosClientException cce = new CosClientException("Unable to execute Response handle: " + e.getMessage(), e);
            throw cce;
        }
        finally {
            if (!responseHandler.needsConnectionLeftOpen()) {
                httpRequest.releaseConnection();
            }
        }
    }

    private InputStream makeResettable(InputStream content) {
        block3: {
            if (!content.markSupported() && content instanceof FileInputStream) {
                try {
                    return new ResettableInputStream((FileInputStream)content);
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("For the record; ignore otherwise", (Throwable)e);
                }
            }
        }
        return content;
    }

    private InputStream buffer(InputStream content) {
        if (!content.markSupported()) {
            content = new SdkBufferedInputStream(content);
        }
        return content;
    }

    private void checkInterrupted() throws CosClientException {
        if (Thread.interrupted()) {
            throw new CosClientException("operation has been interrupted!");
        }
    }
}

