/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.meta;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.HttpRequestBase;

public class COSObjectInputStream
extends InputStream {
    private InputStream in;
    private HttpRequestBase httpRequest;
    private boolean eof;

    public COSObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        this.in = in;
        this.httpRequest = httpRequest;
    }

    private void doAbort() {
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        this.closeStream(this.in);
    }

    @Override
    public int read() throws IOException {
        int value = this.in.read();
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int value = this.in.read(b, off, len);
        if (value == -1) {
            this.eof = true;
        }
        return value;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.eof = false;
    }

    private void closeStream(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.eof) {
            this.closeStream(this.in);
            this.httpRequest.releaseConnection();
        } else {
            this.doAbort();
        }
    }

    public void abort() {
        this.doAbort();
    }
}

