/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.track.cls;

public class ClsSessionCredentials {
    private final String secretId;
    private final String secretKey;
    private final String token;
    private final long expiredTime;

    public ClsSessionCredentials(String secretId, String secretKey, String token, long expiredTime) {
        if (secretId == null) {
            throw new IllegalArgumentException("secretId cannot be null.");
        }
        if (secretKey == null) {
            throw new IllegalArgumentException("secretKey cannot be null.");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be null.");
        }
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.expiredTime = expiredTime;
        this.token = token;
    }

    public boolean isValid() {
        long current = System.currentTimeMillis() / 1000L;
        return current <= this.expiredTime - 60L;
    }

    public String getToken() {
        return this.token;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public long getExpiredTime() {
        return this.expiredTime;
    }
}

