/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.traceroute;

import android.os.SystemClock;
import android.text.TextUtils;
import com.tencent.qcloud.network.sonar.Sonar;
import com.tencent.qcloud.network.sonar.SonarCallback;
import com.tencent.qcloud.network.sonar.SonarRequest;
import com.tencent.qcloud.network.sonar.SonarResult;
import com.tencent.qcloud.network.sonar.SonarType;
import com.tencent.qcloud.network.sonar.command.CommandStatus;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteNodeResult;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteResult;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteTask;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import java.util.ArrayList;

public class TracerouteSonar
implements Sonar<TracerouteResult> {
    protected final String TAG = this.getClass().getSimpleName();
    private final Config config = new Config();
    private SonarCallback.Step<TracerouteNodeResult> stepCallback;
    private boolean isUserStop = false;
    private TracerouteTask task;

    @Override
    public SonarResult<TracerouteResult> start(SonarRequest request) {
        if (!request.isNetworkAvailable()) {
            return new SonarResult<TracerouteResult>(SonarType.TRACEROUTE, new Exception("Network is not available"));
        }
        if (TextUtils.isEmpty((CharSequence)request.getIp())) {
            return new SonarResult<TracerouteResult>(SonarType.TRACEROUTE, new Exception("request ip is null"));
        }
        long startTime = System.currentTimeMillis();
        SonarLog.d(this.TAG, "run thread:" + Thread.currentThread().getId() + " name:" + Thread.currentThread().getName());
        this.isUserStop = false;
        ArrayList<TracerouteNodeResult> nodeResults = new ArrayList<TracerouteNodeResult>();
        int countUnreachable = 0;
        long timestamp = System.currentTimeMillis() / 1000L;
        long start = SystemClock.elapsedRealtime();
        for (int i = 1; i <= this.config.maxHop && !this.isUserStop; ++i) {
            this.task = new TracerouteTask(request.getIp(), i, this.config.countPerRoute, this.stepCallback);
            TracerouteNodeResult node = this.task.run();
            SonarLog.d(this.TAG, String.format("[thread]:%d, [trace node]:%s", Thread.currentThread().getId(), node == null ? "null" : node.toString()));
            if (node == null) continue;
            nodeResults.add(node);
            if (node.isFinalRoute()) break;
            countUnreachable = TextUtils.equals((CharSequence)"*", (CharSequence)node.getRouteIp()) ? ++countUnreachable : 0;
            if (countUnreachable == 10) break;
        }
        TracerouteResult result = new TracerouteResult(request.getIp(), timestamp, this.isUserStop ? CommandStatus.CMD_STATUS_USER_STOP : CommandStatus.CMD_STATUS_SUCCESSFUL, request.getHost(), System.currentTimeMillis() - startTime);
        result.getTracerouteNodeResults().addAll(nodeResults);
        return new SonarResult<TracerouteResult>(SonarType.TRACEROUTE, result);
    }

    @Override
    public void stop() {
        this.isUserStop = true;
        if (this.task != null) {
            this.task.stop();
        }
    }

    public static class Config {
        private int maxHop = 32;
        private int countPerRoute = 3;

        public int getMaxHop() {
            return this.maxHop;
        }

        public Config setMaxHop(int maxHop) {
            this.maxHop = Math.max(1, Math.min(maxHop, 128));
            return this;
        }

        public int getCountPerRoute() {
            return this.countPerRoute;
        }

        public Config setCountPerRoute(int countPerRoute) {
            this.countPerRoute = Math.max(1, Math.min(countPerRoute, 3));
            return this;
        }
    }
}

