/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.traceroute;

import com.tencent.qcloud.network.sonar.command.CommandStatus;
import com.tencent.qcloud.network.sonar.command.JsonSerializable;
import com.tencent.qcloud.network.sonar.traceroute.TracerouteNodeResult;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TracerouteResult
implements JsonSerializable {
    private String targetIp;
    private List<TracerouteNodeResult> tracerouteNodeResults;
    private long timestamp;
    private CommandStatus status;
    private String host;
    private long timeConsuming;

    public TracerouteResult(String targetIp, long timestamp, CommandStatus status, String host, long timeConsuming) {
        this.targetIp = targetIp;
        this.timestamp = timestamp;
        this.status = status;
        this.host = host;
        this.timeConsuming = timeConsuming;
        this.tracerouteNodeResults = new ArrayList<TracerouteNodeResult>();
    }

    public String getTargetIp() {
        return this.targetIp;
    }

    public List<TracerouteNodeResult> getTracerouteNodeResults() {
        return this.tracerouteNodeResults;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public CommandStatus getCommandStatus() {
        return this.status;
    }

    public long getTimeConsuming() {
        return this.timeConsuming;
    }

    public int getHopCount() {
        if (this.tracerouteNodeResults != null) {
            return this.tracerouteNodeResults.size();
        }
        return 0;
    }

    public int getTotalDelay() {
        if (this.tracerouteNodeResults != null) {
            int total = 0;
            for (TracerouteNodeResult node : this.tracerouteNodeResults) {
                if (node == null || (float)node.averageDelay() <= 0.0f) continue;
                total += node.averageDelay();
            }
            return total;
        }
        return 0;
    }

    public float getLossRate() {
        if (this.tracerouteNodeResults != null) {
            int count = 0;
            float total = 0.0f;
            for (TracerouteNodeResult node : this.tracerouteNodeResults) {
                if (node == null) continue;
                ++count;
                total += node.lossRate();
            }
            return total / (float)count;
        }
        return 1.0f;
    }

    public String getNodeResultsString() {
        JSONObject json;
        block4: {
            json = new JSONObject();
            JSONArray jarr = new JSONArray();
            if (this.tracerouteNodeResults != null && !this.tracerouteNodeResults.isEmpty()) {
                for (TracerouteNodeResult result : this.tracerouteNodeResults) {
                    if (result == null || result.toJson().length() == 0) continue;
                    jarr.put((Object)result.toJson());
                }
            }
            try {
                json.put("traceroute_node_results", (Object)jarr);
            }
            catch (JSONException e) {
                if (!SonarLog.openLog) break block4;
                e.printStackTrace();
            }
        }
        return json.toString();
    }

    public String toString() {
        return this.toJson().toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject json;
        block4: {
            json = new JSONObject();
            JSONArray jarr = new JSONArray();
            if (this.tracerouteNodeResults != null && !this.tracerouteNodeResults.isEmpty()) {
                for (TracerouteNodeResult result : this.tracerouteNodeResults) {
                    if (result == null || result.toJson().length() == 0) continue;
                    jarr.put((Object)result.toJson());
                }
            }
            try {
                json.put("host", (Object)this.host);
                json.put("host_ip", (Object)this.targetIp);
                json.put("timestamp", this.timestamp);
                json.put("command_status", (Object)this.status.getName().toString());
                json.put("hopCount", this.getHopCount());
                json.put("totalDelay", this.getTotalDelay());
                json.put("lossRate", (double)this.getLossRate());
                json.put("timeConsuming", this.timeConsuming);
                json.put("traceroute_node_results", (Object)jarr);
            }
            catch (JSONException e) {
                if (!SonarLog.openLog) break block4;
                e.printStackTrace();
            }
        }
        return json;
    }
}

