/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.ping;

import android.text.TextUtils;
import com.tencent.qcloud.network.sonar.Sonar;
import com.tencent.qcloud.network.sonar.SonarCallback;
import com.tencent.qcloud.network.sonar.SonarRequest;
import com.tencent.qcloud.network.sonar.SonarResult;
import com.tencent.qcloud.network.sonar.SonarType;
import com.tencent.qcloud.network.sonar.ping.PingResult;
import com.tencent.qcloud.network.sonar.utils.SonarLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;

public class PingSonar
implements Sonar<PingResult> {
    private final int count = 10;
    private final int size = 56;
    private final int interval = 200;
    public SonarCallback.Step<String> stepCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SonarResult<PingResult> start(SonarRequest request) {
        if (!request.isNetworkAvailable()) {
            return new SonarResult<PingResult>(SonarType.PING, new Exception("Network is not available"));
        }
        if (TextUtils.isEmpty((CharSequence)request.getIp())) {
            return new SonarResult<PingResult>(SonarType.PING, new Exception("request ip is null"));
        }
        long startTime = System.currentTimeMillis();
        String cmdPing = "ping";
        if (null != request.getIp() && request.getIp().contains(":")) {
            cmdPing = "ping6";
        }
        String cmd = String.format(Locale.getDefault(), "%s -n -i %f -s %d -c %d %s", cmdPing, 0.2, 56, 10, request.getIp());
        Process process = null;
        StringBuilder str = new StringBuilder();
        BufferedReader reader = null;
        BufferedReader errorReader = null;
        try {
            String line;
            process = Runtime.getRuntime().exec(cmd);
            if (null == process) {
                SonarResult<PingResult> sonarResult = new SonarResult<PingResult>(SonarType.PING, new Exception("ping process is null"));
                return sonarResult;
            }
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = reader.readLine()) != null) {
                str.append(line).append("\n");
                if (null == this.stepCallback) continue;
                this.stepCallback.step(line);
            }
            while ((line = errorReader.readLine()) != null) {
                str.append(line);
                if (null == this.stepCallback) continue;
                this.stepCallback.step(line);
            }
            reader.close();
            errorReader.close();
            process.waitFor();
        }
        catch (IOException e) {
            if (null != this.stepCallback) {
                this.stepCallback.step(e.getMessage());
            } else if (SonarLog.openLog) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException e) {
            if (null != this.stepCallback) {
                this.stepCallback.step(e.getMessage());
            } else if (SonarLog.openLog) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            if (null != this.stepCallback) {
                this.stepCallback.step(e.getMessage());
            } else if (SonarLog.openLog) {
                e.printStackTrace();
            }
        }
        finally {
            block41: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (process != null) {
                        process.destroy();
                    }
                }
                catch (Exception e) {
                    if (null != this.stepCallback) {
                        this.stepCallback.step(e.getMessage());
                    }
                    if (!SonarLog.openLog) break block41;
                    e.printStackTrace();
                }
            }
        }
        PingResult pingResult = new PingResult(str.toString(), request.getHost(), request.getIp(), 56, 200);
        pingResult.timeConsuming = System.currentTimeMillis() - startTime;
        return new SonarResult<PingResult>(SonarType.PING, pingResult);
    }

    @Override
    public void stop() {
    }
}

