/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.http;

import android.text.TextUtils;
import com.tencent.qcloud.network.sonar.Sonar;
import com.tencent.qcloud.network.sonar.SonarRequest;
import com.tencent.qcloud.network.sonar.SonarResult;
import com.tencent.qcloud.network.sonar.SonarType;
import com.tencent.qcloud.network.sonar.http.HttpResult;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class HttpSonar
implements Sonar<HttpResult> {
    public boolean bypassProxy = false;

    public HttpSonar(boolean bypassProxy) {
        this.bypassProxy = bypassProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SonarResult<HttpResult> start(SonarRequest request) {
        if (!request.isNetworkAvailable()) {
            return new SonarResult<HttpResult>(SonarType.HTTP, new Exception("Network is not available"));
        }
        if (TextUtils.isEmpty((CharSequence)request.getHost())) {
            return new SonarResult<HttpResult>(SonarType.HTTP, new Exception("request host is null"));
        }
        HttpResult httpResult = new HttpResult();
        httpResult.domain = request.getHost();
        httpResult.bypassProxy = this.bypassProxy;
        HttpURLConnection connection = null;
        try {
            URL url = new URL("https://" + request.getHost());
            httpResult.url = url.toString();
            if (this.bypassProxy) {
                Proxy proxy = Proxy.NO_PROXY;
                connection = (HttpURLConnection)url.openConnection(proxy);
            } else {
                connection = (HttpURLConnection)url.openConnection();
            }
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setRequestMethod("HEAD");
            long startTime = System.currentTimeMillis();
            connection.connect();
            int responseCode = connection.getResponseCode();
            long endTime = System.currentTimeMillis();
            long duration = endTime - startTime;
            httpResult.responseCode = responseCode;
            httpResult.timeConsuming = duration;
            httpResult.responseHeaders = connection.getHeaderFields();
        }
        catch (Exception e) {
            SonarResult<HttpResult> sonarResult = new SonarResult<HttpResult>(SonarType.HTTP, e);
            return sonarResult;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return new SonarResult<HttpResult>(SonarType.HTTP, httpResult);
    }

    @Override
    public void stop() {
    }
}

