/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.network.sonar.command;

import com.tencent.qcloud.network.sonar.utils.SonarLog;
import com.tencent.qcloud.network.sonar.utils.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class CommandTask<T> {
    protected final String TAG = this.getClass().getSimpleName();
    protected String command;
    protected Process process;
    protected boolean isRunning = false;
    protected InputStream dataInputStream = null;
    protected InputStream errorInputStream = null;
    protected static float COMMAND_ELAPSED_TIME = 0.0f;
    protected T resultData;

    protected Process createProcess(String cmd) throws IOException {
        return Runtime.getRuntime().exec(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String execCommand(String command) throws InterruptedException, IOException {
        SonarLog.d(this.TAG, "[command]:" + command);
        this.process = this.createProcess(command);
        int status = this.process.waitFor();
        SonarLog.d(this.TAG, "[status]: " + status);
        this.dataInputStream = this.process.getInputStream();
        this.errorInputStream = this.process.getErrorStream();
        BufferedInputStream dataBufferedStream = new BufferedInputStream(this.dataInputStream);
        BufferedInputStream errorBufferedStream = new BufferedInputStream(this.errorInputStream);
        String dataStr = "";
        String errorStr = "";
        try {
            dataStr = this.readData(dataBufferedStream);
            errorStr = this.readData(errorBufferedStream);
        }
        catch (IOException e) {
            block4: {
                try {
                    if (!SonarLog.openLog) break block4;
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Utils.closeAllCloseable(dataBufferedStream, this.dataInputStream, errorBufferedStream, this.errorInputStream);
                    this.process.destroy();
                    this.parseErrorInfo(errorStr);
                    throw throwable;
                }
            }
            Utils.closeAllCloseable(dataBufferedStream, this.dataInputStream, errorBufferedStream, this.errorInputStream);
            this.process.destroy();
            this.parseErrorInfo(errorStr);
        }
        Utils.closeAllCloseable(dataBufferedStream, this.dataInputStream, errorBufferedStream, this.errorInputStream);
        this.process.destroy();
        this.parseErrorInfo(errorStr);
        return dataStr;
    }

    protected abstract T run();

    protected abstract void stop();

    protected abstract void parseInputInfo(String var1);

    protected abstract void parseErrorInfo(String var1);

    protected String readData(InputStream input) throws IOException {
        int len;
        if (input == null) {
            return null;
        }
        byte[] buffer = new byte[1024];
        byte[] cache = null;
        while ((len = input.read(buffer)) > 0) {
            if (cache == null) {
                cache = Arrays.copyOf(buffer, len);
                continue;
            }
            int cacheLen = cache.length;
            byte[] tmp = new byte[cacheLen + len];
            System.arraycopy(cache, 0, tmp, 0, cacheLen);
            System.arraycopy(buffer, 0, tmp, cacheLen, len);
            cache = tmp;
        }
        if (cache == null) {
            return null;
        }
        return new String(cache, Charset.forName("UTF-8"));
    }

    public T getResultData() {
        return this.resultData;
    }
}

