/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger.channel;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.tencent.qcloud.core.logger.LogEntity;
import com.tencent.qcloud.core.logger.channel.BaseLogChannel;

public class LogcatChannel
extends BaseLogChannel {
    @Override
    public void log(LogEntity entity) {
        if (!this.isLoggable(entity)) {
            return;
        }
        String message = entity.getLogcatString();
        switch (entity.getLevel()) {
            case VERBOSE: {
                this.v(entity.getTag(), message, entity.getThrowable());
                break;
            }
            case DEBUG: {
                this.d(entity.getTag(), message, entity.getThrowable());
                break;
            }
            case INFO: {
                this.i(entity.getTag(), message, entity.getThrowable());
                break;
            }
            case WARN: {
                this.w(entity.getTag(), message, entity.getThrowable());
                break;
            }
            case ERROR: {
                this.e(entity.getTag(), message, entity.getThrowable());
            }
        }
    }

    private int v(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.v((String)tag, (String)message);
        }
        return Log.v((String)tag, (String)message, (Throwable)tr);
    }

    private int d(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.d((String)tag, (String)message);
        }
        return Log.d((String)tag, (String)message, (Throwable)tr);
    }

    private int i(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.i((String)tag, (String)message);
        }
        return Log.i((String)tag, (String)message, (Throwable)tr);
    }

    private int w(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.w((String)tag, (String)message);
        }
        return Log.w((String)tag, (String)message, (Throwable)tr);
    }

    private int e(String tag, String message, @Nullable Throwable tr) {
        if (tr == null) {
            return Log.e((String)tag, (String)message);
        }
        return Log.e((String)tag, (String)message, (Throwable)tr);
    }

    private boolean isLoggable(LogEntity entity) {
        if (!this.isEnabled() || entity == null) {
            return false;
        }
        if (!entity.getLevel().isLoggable(this.getMinLevel())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)entity.getTag()) || entity.getTag().length() >= 23) {
            return false;
        }
        return Log.isLoggable((String)entity.getTag(), (int)(entity.getLevel().getPriority() + 1));
    }
}

