/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import androidx.annotation.Nullable;
import com.tencent.qcloud.core.logger.COSLogger;
import com.tencent.qcloud.core.logger.LogCategory;
import com.tencent.qcloud.core.logger.LogLevel;

public final class QCloudLogger {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    private QCloudLogger() {
    }

    public static void v(String tag, String format, Object ... args) {
        QCloudLogger.print(2, tag, null, format, args);
    }

    public static void v(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(2, tag, tr, format, args);
    }

    public static void d(String tag, String format, Object ... args) {
        QCloudLogger.print(3, tag, null, format, args);
    }

    public static void d(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(3, tag, tr, format, args);
    }

    public static void i(String tag, String format, Object ... args) {
        QCloudLogger.print(4, tag, null, format, args);
    }

    public static void i(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(4, tag, tr, format, args);
    }

    public static void w(String tag, String format, Object ... args) {
        QCloudLogger.print(5, tag, null, format, args);
    }

    public static void w(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(5, tag, tr, format, args);
    }

    public static void e(String tag, String format, Object ... args) {
        QCloudLogger.print(6, tag, null, format, args);
    }

    public static void e(String tag, Throwable tr, String format, Object ... args) {
        QCloudLogger.print(6, tag, tr, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(int priority, String tag, @Nullable Throwable tr, String format, Object ... args) {
        LogLevel logLevel;
        String message;
        try {
            message = args != null && args.length > 0 ? String.format(format, args) : format;
        }
        catch (Exception e) {
            message = format + ": !!!! Log format exception: ";
        }
        switch (priority) {
            case 3: {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case 4: {
                logLevel = LogLevel.INFO;
                break;
            }
            case 5: {
                logLevel = LogLevel.WARN;
                break;
            }
            case 6: {
                logLevel = LogLevel.ERROR;
                break;
            }
            default: {
                logLevel = LogLevel.VERBOSE;
            }
        }
        Class<QCloudLogger> clazz = QCloudLogger.class;
        synchronized (QCloudLogger.class) {
            COSLogger.getInstance().log(logLevel, LogCategory.PROCESS, tag, message, tr);
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return;
        }
    }
}

