/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.logger;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.qcloud.core.logger.LogCategory;
import com.tencent.qcloud.core.logger.LogLevel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;

public class LogEntity {
    private final long timestamp = System.currentTimeMillis();
    private final LogLevel level;
    private final LogCategory category;
    private final String tag;
    private final String message;
    private final String threadName = Thread.currentThread().getName();
    @Nullable
    private final Map<String, String> extras;
    @Nullable
    private final Throwable throwable;

    public LogEntity(LogLevel level, LogCategory category, String tag, String message, @Nullable Map<String, String> extras, @Nullable Throwable throwable) {
        this.level = level;
        this.category = category;
        this.tag = tag;
        this.message = message;
        this.extras = extras;
        this.throwable = throwable;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public LogLevel getLevel() {
        return this.level;
    }

    public LogCategory getCategory() {
        return this.category;
    }

    public String getTag() {
        return this.tag;
    }

    public String getMessage() {
        return this.message;
    }

    public String getThreadName() {
        return this.threadName;
    }

    @Nullable
    public Map<String, String> getExtras() {
        return this.extras;
    }

    @Nullable
    public Throwable getThrowable() {
        return this.throwable;
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.level).append("/");
        builder.append(LogEntity.timeUtils(this.timestamp, "yyyy-MM-dd HH:mm:ss"));
        builder.append("[").append(this.threadName).append("]");
        builder.append("[").append((Object)this.category).append(" ").append(this.tag).append("]");
        builder.append("[").append(this.message).append("]");
        builder.append("[").append(this.extras).append("]");
        if (this.throwable != null) {
            builder.append(" * Exception :\n").append(Log.getStackTraceString((Throwable)this.throwable));
        }
        builder.append("\n");
        return builder.toString();
    }

    public String getLogcatString() {
        String message = this.getExtras() == null || this.getExtras().isEmpty() ? String.format("[%s][%s] %s", this.getCategory().name(), this.getThreadName(), this.getMessage()) : String.format("[%s][%s] %s - %s", this.getCategory().name(), this.getThreadName(), this.getMessage(), this.getExtras());
        return message;
    }

    public long getLength() {
        return (this.message != null ? this.message.length() : 0) + 40;
    }

    private static String timeUtils(long timestamp, String dateFormat) {
        Date dat = new Date(timestamp);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(dat);
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.CHINA);
        return format.format(gc.getTime());
    }
}

