/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.ResponseFileConverter;
import com.tencent.qcloud.core.http.SelfCloseConverter;
import java.io.IOException;
import java.io.InputStream;

public abstract class ResponseBodyConverter<T> {
    public abstract T convert(HttpResponse<T> var1) throws QCloudClientException, QCloudServiceException;

    public static ResponseBodyConverter<Void> file(String filePath) {
        return ResponseBodyConverter.file(filePath, -1L);
    }

    public static ResponseBodyConverter<Void> file(String filePath, long offset) {
        return new ResponseFileConverter<Void>(filePath, offset);
    }

    public static ResponseBodyConverter<String> string() {
        return new StringConverter();
    }

    public static ResponseBodyConverter<byte[]> bytes() {
        return new BytesConverter();
    }

    public static ResponseBodyConverter<InputStream> inputStream() {
        return new InputStreamConverter();
    }

    private static final class InputStreamConverter
    extends ResponseBodyConverter<InputStream>
    implements SelfCloseConverter {
        private InputStreamConverter() {
        }

        @Override
        public InputStream convert(HttpResponse<InputStream> response) throws QCloudClientException, QCloudServiceException {
            return response.byteStream();
        }
    }

    private static final class BytesConverter
    extends ResponseBodyConverter<byte[]> {
        private BytesConverter() {
        }

        @Override
        public byte[] convert(HttpResponse<byte[]> response) throws QCloudClientException, QCloudServiceException {
            try {
                return response.bytes();
            }
            catch (IOException e) {
                throw new QCloudClientException(e);
            }
        }
    }

    private static final class StringConverter
    extends ResponseBodyConverter<String> {
        private StringConverter() {
        }

        @Override
        public String convert(HttpResponse<String> response) throws QCloudClientException, QCloudServiceException {
            try {
                return response.string();
            }
            catch (IOException e) {
                throw new QCloudClientException(e);
            }
        }
    }
}

