/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.http.CallMetricsListener;
import com.tencent.qcloud.core.http.ConnectionRepository;
import com.tencent.qcloud.core.http.HttpLogger;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.NetworkClient;
import com.tencent.qcloud.core.http.OkHttpClientImpl;
import com.tencent.qcloud.core.http.QCloudHttpRequest;
import com.tencent.qcloud.core.http.QCloudHttpRetryHandler;
import com.tencent.qcloud.core.logger.COSLogger;
import com.tencent.qcloud.core.task.QCloudTask;
import com.tencent.qcloud.core.task.RetryStrategy;
import com.tencent.qcloud.core.task.TaskManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import okhttp3.Call;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;

public final class QCloudHttpClient {
    public static final String HTTP_LOG_TAG = "QCloudHttp";
    public static final String QUIC_LOG_TAG = "QCloudQuic";
    private String networkClientType = OkHttpClientImpl.class.getName();
    private static Map<Integer, NetworkClient> networkClientMap = new ConcurrentHashMap<Integer, NetworkClient>(2);
    private static OkHttpClient.Builder okHttpClientBuilder;
    public static final Object okHttpClientBuilderLock;
    private OkHttpClientImpl okhttpNetworkClient;
    private final TaskManager taskManager;
    private final HttpLogger httpLogger;
    private final Set<String> verifiedHost;
    private final Map<String, List<InetAddress>> dnsMap;
    private final ArrayList<QCloudDnsFetch> dnsFetchs;
    private final ConnectionRepository connectionRepository;
    private boolean dnsCache = true;
    private static volatile QCloudHttpClient gDefault;
    private HostnameVerifier mHostnameVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            if (QCloudHttpClient.this.verifiedHost.size() > 0) {
                for (String host : QCloudHttpClient.this.verifiedHost) {
                    if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(host, session)) continue;
                    return true;
                }
            }
            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostname, session);
        }
    };
    private Dns mDns = new Dns(){

        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            List<InetAddress> dns = null;
            if (QCloudHttpClient.this.dnsMap.containsKey(hostname)) {
                dns = (List)QCloudHttpClient.this.dnsMap.get(hostname);
            }
            if (dns == null || dns.size() == 0) {
                for (QCloudDnsFetch dnsFetch : QCloudHttpClient.this.dnsFetchs) {
                    if (dnsFetch == null) continue;
                    try {
                        dns = dnsFetch.fetch(hostname);
                        if (dns == null) continue;
                        break;
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                }
            }
            if (dns == null || dns.size() == 0) {
                try {
                    dns = Dns.SYSTEM.lookup(hostname);
                }
                catch (UnknownHostException e) {
                    COSLogger.wNetwork(QCloudHttpClient.HTTP_LOG_TAG, "system dns failed, retry cache dns records.");
                }
            }
            if (!(dns != null && dns.size() != 0 || QCloudHttpClient.this.dnsCache)) {
                throw new UnknownHostException("can not resolve host name " + hostname);
            }
            if (dns == null || dns.size() == 0) {
                try {
                    dns = QCloudHttpClient.this.connectionRepository.getDnsRecord(hostname);
                }
                catch (UnknownHostException e) {
                    COSLogger.wNetwork(QCloudHttpClient.HTTP_LOG_TAG, "Not found dns in cache records.");
                }
            }
            if (dns == null || dns.size() <= 0) {
                throw new UnknownHostException(hostname);
            }
            ConnectionRepository.getInstance().insertDnsRecordCache(hostname, dns);
            return dns;
        }
    };
    private EventListener.Factory mEventListenerFactory = new EventListener.Factory(){

        public EventListener create(Call call) {
            return new CallMetricsListener(call);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QCloudHttpClient getDefault() {
        if (gDefault != null) return gDefault;
        Class<QCloudHttpClient> clazz = QCloudHttpClient.class;
        synchronized (QCloudHttpClient.class) {
            if (gDefault != null) return gDefault;
            gDefault = new Builder().build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return gDefault;
        }
    }

    public void addVerifiedHost(String hostname) {
        if (hostname != null) {
            this.verifiedHost.add(hostname);
        }
    }

    public void addDnsRecord(@NonNull String hostName, @NonNull String[] ipAddress) throws UnknownHostException {
        if (ipAddress.length > 0) {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>(ipAddress.length);
            for (String ip : ipAddress) {
                addresses.add(InetAddress.getByName(ip));
            }
            this.dnsMap.put(hostName, addresses);
        }
    }

    public void addDnsFetch(@NonNull QCloudDnsFetch dnsFetch) {
        this.dnsFetchs.add(dnsFetch);
    }

    private QCloudHttpClient(Builder b) {
        this.verifiedHost = new HashSet<String>(5);
        this.dnsMap = new ConcurrentHashMap<String, List<InetAddress>>(3);
        this.dnsFetchs = new ArrayList(3);
        this.taskManager = TaskManager.getInstance();
        this.connectionRepository = ConnectionRepository.getInstance();
        this.httpLogger = new HttpLogger();
        this.okhttpNetworkClient = new OkHttpClientImpl();
        this.okhttpNetworkClient.init(b, this.hostnameVerifier(), this.mDns, this.httpLogger);
        NetworkClient networkClient = b.networkClient;
        if (networkClient == null) {
            networkClient = new OkHttpClientImpl();
        }
        this.networkClientType = networkClient.getClass().getName();
        if (OkHttpClientImpl.class.getName().equals(this.networkClientType) && networkClient instanceof OkHttpClientImpl) {
            if (this.okhttpNetworkClient == null) {
                this.okhttpNetworkClient = (OkHttpClientImpl)networkClient;
                this.okhttpNetworkClient.init(b, this.hostnameVerifier(), this.mDns, this.httpLogger);
            }
        } else {
            int hashCode = this.networkClientType.hashCode();
            if (!networkClientMap.containsKey(hashCode)) {
                networkClient.init(b, this.hostnameVerifier(), this.mDns, this.httpLogger);
                if (!"com.tencent.qcloud.quic.QuicClientImpl".equals(this.networkClientType)) {
                    networkClient.enableQCloudInterceptor();
                }
                networkClientMap.put(hashCode, networkClient);
            }
        }
        this.connectionRepository.addPrefetchHosts(b.prefetchHost);
        this.connectionRepository.init();
    }

    public void setNetworkClientType(Builder b) {
        this.okhttpNetworkClient = new OkHttpClientImpl();
        this.okhttpNetworkClient.init(b, this.hostnameVerifier(), this.mDns, this.httpLogger);
        NetworkClient networkClient = b.networkClient;
        if (networkClient != null) {
            this.networkClientType = networkClient.getClass().getName();
            if (OkHttpClientImpl.class.getName().equals(this.networkClientType) && networkClient instanceof OkHttpClientImpl) {
                if (this.okhttpNetworkClient == null) {
                    this.okhttpNetworkClient = (OkHttpClientImpl)networkClient;
                    this.okhttpNetworkClient.init(b, this.hostnameVerifier(), this.mDns, this.httpLogger);
                }
            } else {
                int hashCode = this.networkClientType.hashCode();
                if (!networkClientMap.containsKey(hashCode)) {
                    networkClient.init(b, this.hostnameVerifier(), this.mDns, this.httpLogger);
                    if (!"com.tencent.qcloud.quic.QuicClientImpl".equals(this.networkClientType)) {
                        networkClient.enableQCloudInterceptor();
                    }
                    networkClientMap.put(hashCode, networkClient);
                }
            }
        }
    }

    public List<HttpTask> getTasksByTag(String tag) {
        ArrayList<HttpTask> tasks = new ArrayList<HttpTask>();
        if (tag == null) {
            return tasks;
        }
        List<QCloudTask> taskManagerSnapshot = this.taskManager.snapshot();
        for (QCloudTask task : taskManagerSnapshot) {
            if (!(task instanceof HttpTask) || !tag.equals(task.getTag())) continue;
            tasks.add((HttpTask)task);
        }
        return tasks;
    }

    public <T> HttpTask<T> resolveRequest(HttpRequest<T> request) {
        return this.handleRequest(request, null, null);
    }

    public <T> HttpTask<T> resolveRequest(HttpRequest<T> request, String networkClientType) {
        return this.handleRequest(request, null, networkClientType);
    }

    public <T> HttpTask<T> resolveRequest(QCloudHttpRequest<T> request, QCloudCredentialProvider credentialProvider) {
        return this.handleRequest(request, credentialProvider, null);
    }

    public <T> HttpTask<T> resolveRequest(QCloudHttpRequest<T> request, QCloudCredentialProvider credentialProvider, String networkClientType) {
        return this.handleRequest(request, credentialProvider, networkClientType);
    }

    private HostnameVerifier hostnameVerifier() {
        return this.mHostnameVerifier;
    }

    private <T> HttpTask<T> handleRequest(HttpRequest<T> request, QCloudCredentialProvider credentialProvider, String networkClientType) {
        if (TextUtils.isEmpty((CharSequence)networkClientType)) {
            networkClientType = this.networkClientType;
        }
        if (OkHttpClientImpl.class.getName().equals(networkClientType)) {
            return new HttpTask<T>(request, credentialProvider, this.okhttpNetworkClient);
        }
        return new HttpTask<T>(request, credentialProvider, networkClientMap.get(networkClientType.hashCode()));
    }

    static {
        okHttpClientBuilderLock = new Object();
    }

    public static final class Builder {
        int connectionTimeout = 15000;
        int socketTimeout = 30000;
        RetryStrategy retryStrategy;
        QCloudHttpRetryHandler qCloudHttpRetryHandler;
        OkHttpClient.Builder mBuilder;
        NetworkClient networkClient;
        List<String> prefetchHost = new LinkedList<String>();
        boolean dnsCache = false;
        boolean verifySSLEnable = true;
        boolean redirectEnable = false;
        byte[] clientCertificateBytes;
        char[] clientCertificatePassword;

        public Builder setConnectionTimeout(int connectionTimeout) {
            if (connectionTimeout < 3000) {
                throw new IllegalArgumentException("connection timeout must be larger than 3 seconds.");
            }
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            if (socketTimeout < 3000) {
                throw new IllegalArgumentException("socket timeout must be larger than 3 seconds.");
            }
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setRetryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public Builder setQCloudHttpRetryHandler(QCloudHttpRetryHandler qCloudHttpRetryHandler) {
            this.qCloudHttpRetryHandler = qCloudHttpRetryHandler;
            return this;
        }

        public Builder setInheritBuilder(OkHttpClient.Builder builder) {
            this.mBuilder = builder;
            return this;
        }

        public Builder setNetworkClient(NetworkClient networkClient) {
            this.networkClient = networkClient;
            return this;
        }

        public Builder addPrefetchHost(String host) {
            this.prefetchHost.add(host);
            return this;
        }

        public Builder dnsCache(boolean dnsCache) {
            this.dnsCache = dnsCache;
            return this;
        }

        public Builder setVerifySSLEnable(boolean verifySSLEnable) {
            this.verifySSLEnable = verifySSLEnable;
            return this;
        }

        public Builder setClientCertificate(byte[] certificateBytes, char[] password) {
            this.clientCertificateBytes = certificateBytes;
            this.clientCertificatePassword = password;
            return this;
        }

        public Builder setRedirectEnable(boolean redirectEnable) {
            this.redirectEnable = redirectEnable;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QCloudHttpClient build() {
            if (this.retryStrategy == null) {
                this.retryStrategy = RetryStrategy.DEFAULT;
            }
            if (this.qCloudHttpRetryHandler != null) {
                this.retryStrategy.setRetryHandler(this.qCloudHttpRetryHandler);
            }
            Object object = okHttpClientBuilderLock;
            synchronized (object) {
                if (this.mBuilder == null) {
                    if (okHttpClientBuilder == null) {
                        okHttpClientBuilder = new OkHttpClient.Builder();
                    }
                    this.mBuilder = okHttpClientBuilder;
                }
            }
            return new QCloudHttpClient(this);
        }
    }

    public static interface QCloudDnsFetch {
        public List<InetAddress> fetch(String var1) throws UnknownHostException;
    }
}

