/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudClientException;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.common.QCloudServiceException;
import com.tencent.qcloud.core.http.HttpRequest;
import com.tencent.qcloud.core.http.HttpResponse;
import com.tencent.qcloud.core.http.HttpResult;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.http.ProgressBody;
import com.tencent.qcloud.core.http.ResponseBodyConverter;
import com.tencent.qcloud.core.http.SelfCloseConverter;
import com.tencent.qcloud.core.http.interceptor.QCloudRetryInterceptor;
import com.tencent.qcloud.core.util.OkhttpInternalUtils;
import java.io.Closeable;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;

public abstract class NetworkProxy<T> {
    protected HttpTaskMetrics metrics;
    protected String identifier;
    protected QCloudProgressListener mProgressListener;
    private QCloudRetryInterceptor mRetryInterceptor;

    public void setRetryInterceptor(QCloudRetryInterceptor qCloudRetryInterceptor) {
        this.mRetryInterceptor = qCloudRetryInterceptor;
    }

    protected abstract void cancel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected HttpResult<T> executeHttpRequest(HttpRequest<T> httpRequest) throws QCloudClientException, QCloudServiceException {
        HttpResult<T> httpResult;
        QCloudServiceException serviceException;
        QCloudClientException clientException;
        block21: {
            boolean selfCloseConverter;
            Response response;
            block19: {
                clientException = null;
                serviceException = null;
                response = null;
                httpResult = null;
                selfCloseConverter = httpRequest.getResponseBodyConverter() instanceof SelfCloseConverter;
                httpRequest.setOkHttpRequestTag(this.identifier);
                Request okHttpRequest = httpRequest.buildRealRequest();
                response = this.mRetryInterceptor != null ? this.mRetryInterceptor.intercept(this, okHttpRequest) : this.callHttpRequest(okHttpRequest);
                if (response != null) {
                    httpResult = this.convertResponse(httpRequest, response);
                } else {
                    serviceException = new QCloudServiceException("http response is null");
                }
                if (response == null || selfCloseConverter) break block19;
                OkhttpInternalUtils.closeQuietly((Closeable)response);
            }
            try {
                this.disconnect();
            }
            catch (Exception okHttpRequest) {}
            break block21;
            catch (IOException e) {
                block20: {
                    try {
                        if (e.getCause() instanceof QCloudClientException) {
                            clientException = (QCloudClientException)e.getCause();
                        } else if (e.getCause() instanceof QCloudServiceException) {
                            serviceException = (QCloudServiceException)e.getCause();
                        } else {
                            clientException = new QCloudClientException(e);
                        }
                        if (response == null || selfCloseConverter) break block20;
                    }
                    catch (Throwable throwable) {
                        if (response != null && !selfCloseConverter) {
                            OkhttpInternalUtils.closeQuietly(response);
                        }
                        try {
                            this.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    OkhttpInternalUtils.closeQuietly((Closeable)response);
                }
                try {
                    this.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        if (clientException != null) {
            throw clientException;
        }
        if (serviceException != null) {
            throw serviceException;
        }
        return httpResult;
    }

    protected HttpResult<T> convertResponse(HttpRequest<T> request, Response response) throws QCloudClientException, QCloudServiceException {
        HttpResponse<T> httpResponse = new HttpResponse<T>(request, response);
        ResponseBodyConverter<T> converter = request.getResponseBodyConverter();
        if (converter instanceof ProgressBody) {
            ((ProgressBody)((Object)converter)).setProgressListener(this.mProgressListener);
        }
        T content = converter.convert(httpResponse);
        return new HttpResult<T>(httpResponse, content);
    }

    public abstract Response callHttpRequest(Request var1) throws IOException;

    protected void disconnect() {
    }
}

