/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.logger.COSLogger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;

public class HttpConfiguration {
    private static final AtomicLong GLOBAL_TIME_OFFSET = new AtomicLong(0L);
    private static final String RFC822_DATE_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final TimeZone GMT_TIMEZONE = TimeZone.getTimeZone("GMT");
    private static ThreadLocal<SimpleDateFormat> gmtFormatters = new ThreadLocal();

    public static long calculateGlobalTimeOffset(String sDate, Date deviceDate) {
        long offset = GLOBAL_TIME_OFFSET.get();
        HttpConfiguration.calculateGlobalTimeOffset(sDate, deviceDate, 0);
        return Math.abs(offset - GLOBAL_TIME_OFFSET.get());
    }

    public static void calculateGlobalTimeOffset(String sDate, Date deviceDate, int minOffset) {
        try {
            Date serverDate = HttpConfiguration.getFormatter().parse(sDate);
            long clockSkew = (serverDate.getTime() - deviceDate.getTime()) / 1000L;
            if (Math.abs(clockSkew) >= (long)minOffset) {
                GLOBAL_TIME_OFFSET.set(clockSkew);
                COSLogger.iNetwork("QCloudHttp", "NEW TIME OFFSET is " + clockSkew + "s");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public static long getDeviceTimeWithOffset() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getGMTDate(Date date) {
        return HttpConfiguration.getFormatter().format(date);
    }

    private static SimpleDateFormat getFormatter() {
        SimpleDateFormat gmtFormatter = gmtFormatters.get();
        if (gmtFormatter == null) {
            gmtFormatter = new SimpleDateFormat(RFC822_DATE_PATTERN, Locale.US);
            gmtFormatter.setTimeZone(GMT_TIMEZONE);
            gmtFormatter.setLenient(false);
            gmtFormatters.set(gmtFormatter);
        }
        return gmtFormatter;
    }

    public static Date getGMTDate(String strDate) {
        try {
            return HttpConfiguration.getFormatter().parse(strDate);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

