/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.logger.COSLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class CountingInputStream
extends FilterInputStream {
    private long bytesWritten = 0L;
    private long bytesTotal = 0L;
    private long recentReportBytes = 0L;
    private long mark = -1L;
    private QCloudProgressListener progressListener;

    public CountingInputStream(InputStream delegate, long bytesTotal, QCloudProgressListener progressListener) {
        super(delegate);
        this.bytesTotal = bytesTotal;
        this.progressListener = progressListener;
    }

    private void reportProgress() {
        boolean enoughDelta;
        if (this.progressListener == null) {
            return;
        }
        long delta = this.bytesWritten - this.recentReportBytes;
        boolean bl = enoughDelta = delta > 51200L || delta * 10L > this.bytesTotal || this.bytesWritten == this.bytesTotal;
        if (enoughDelta) {
            this.recentReportBytes = this.bytesWritten;
            this.progressListener.onProgress(this.bytesWritten, this.bytesTotal);
        }
    }

    void readBytesInternal(long byteCount) {
        this.bytesWritten += byteCount;
        this.reportProgress();
    }

    long getTotalTransferred() {
        return this.bytesWritten;
    }

    long getBytesTotal() {
        return this.bytesTotal;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (count > 0) {
            this.readBytesInternal(count);
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long count = super.skip(n);
        this.readBytesInternal(count);
        return count;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.bytesWritten;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.bytesWritten = this.mark;
    }

    @Override
    public void close() throws IOException {
        super.close();
        COSLogger.iProcess("Test", "CountingInputStream is closed");
    }
}

