/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.qcloud.core.util.ContextHolder;
import com.tencent.qcloud.core.util.QCloudUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import okhttp3.Dns;

public class ConnectionRepository {
    private Map<String, List<InetAddress>> dnsRecords;
    private static volatile ConnectionRepository instance;
    private LocalDnsCache localDnsCache = new LocalDnsCache(ContextHolder.getAppContext());
    private DnsFetcher dnsFetcher = new DnsFetcher();
    private Executor singleExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConnectionRepository getInstance() {
        if (instance != null) return instance;
        Class<ConnectionRepository> clazz = ConnectionRepository.class;
        synchronized (ConnectionRepository.class) {
            if (instance != null) return instance;
            instance = new ConnectionRepository();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private ConnectionRepository() {
        this.dnsRecords = new ConcurrentHashMap<String, List<InetAddress>>();
        this.singleExecutor = Executors.newSingleThreadExecutor();
    }

    public void addPrefetchHosts(List<String> hosts) {
        this.dnsFetcher.addHosts(hosts);
    }

    public void init() {
        this.init(null);
    }

    public void insertDnsRecordCache(String host, List<InetAddress> inetAddresses) {
        this.insertDnsRecordCache(host, inetAddresses, null);
    }

    public List<InetAddress> getDnsRecord(String host) throws UnknownHostException {
        if (!this.dnsRecords.containsKey(host)) {
            throw new UnknownHostException(host);
        }
        return this.dnsRecords.get(host);
    }

    void init(final AsyncExecuteCompleteListener listener) {
        this.singleExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionRepository.this.addDnsRecordsMap(ConnectionRepository.this.localDnsCache.loadFromLocal());
                ConnectionRepository.this.addDnsRecordsMap(ConnectionRepository.this.dnsFetcher.fetchAll());
                ConnectionRepository.this.localDnsCache.save2Local(ConnectionRepository.this.dnsRecords);
                if (listener != null) {
                    listener.onComplete();
                }
            }
        });
    }

    void insertDnsRecordCache(final String host, final List<InetAddress> inetAddresses, final AsyncExecuteCompleteListener listener) {
        this.singleExecutor.execute(new Runnable(){

            @Override
            public void run() {
                List currentAddresses = (List)ConnectionRepository.this.dnsRecords.get(host);
                if (!ConnectionRepository.this.sameInetAddresses(currentAddresses, inetAddresses)) {
                    ConnectionRepository.this.dnsRecords.put(host, inetAddresses);
                    ConnectionRepository.this.localDnsCache.save2Local(ConnectionRepository.this.dnsRecords);
                }
                if (listener != null) {
                    listener.onComplete();
                }
            }
        });
    }

    private void addDnsRecordsMap(Map<String, List<InetAddress>> dnsRecords) {
        if (dnsRecords != null) {
            this.dnsRecords.putAll(dnsRecords);
        }
    }

    private boolean sameInetAddresses(List<InetAddress> inetAddresses1, List<InetAddress> inetAddresses2) {
        if (inetAddresses1 == null || inetAddresses2 == null || inetAddresses1.size() != inetAddresses2.size()) {
            return false;
        }
        for (int i = 0; i < inetAddresses1.size(); ++i) {
            if (inetAddresses1.get(i).getHostAddress().equals(inetAddresses2.get(i).getHostAddress())) continue;
            return false;
        }
        return true;
    }

    static interface AsyncExecuteCompleteListener {
        public void onComplete();
    }

    static class DnsFetcher {
        private int maxRetry = 2;
        private List<String> hosts = new LinkedList<String>();

        DnsFetcher() {
        }

        synchronized void addHosts(List<String> hosts) {
            this.hosts.addAll(hosts);
        }

        synchronized void addHost(String host) {
            this.hosts.add(host);
        }

        synchronized Map<String, List<InetAddress>> fetchAll() {
            HashMap<String, List<InetAddress>> dnsRecords = new HashMap<String, List<InetAddress>>();
            for (String host : new LinkedList<String>(this.hosts)) {
                List<InetAddress> ips;
                if (TextUtils.isEmpty((CharSequence)host) || (ips = this.fetch(host, this.maxRetry)) == null) continue;
                dnsRecords.put(host, ips);
            }
            return dnsRecords;
        }

        private List<InetAddress> fetch(String host, int maxRetry) {
            if (maxRetry < 0) {
                return null;
            }
            try {
                return Dns.SYSTEM.lookup(host);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return this.fetch(host, maxRetry - 1);
            }
        }
    }

    static class LocalDnsCache {
        private String cacheFilePath;

        LocalDnsCache(Context context) {
            if (context != null) {
                this.cacheFilePath = context.getCacheDir().getAbsolutePath().concat("/cosSdkDnsCache.db");
            }
        }

        synchronized void save2Local(Map<String, List<InetAddress>> dnsRecords) {
            if (this.cacheFilePath == null) {
                return;
            }
            byte[] bytes = QCloudUtils.toBytes(dnsRecords);
            QCloudUtils.writeToFile(this.cacheFilePath, bytes);
        }

        synchronized Map<String, List<InetAddress>> loadFromLocal() {
            Object object;
            if (this.cacheFilePath == null) {
                return null;
            }
            byte[] bytes = QCloudUtils.readBytesFromFile(this.cacheFilePath);
            if (bytes != null && (object = QCloudUtils.toObject(bytes)) instanceof Map) {
                return (Map)object;
            }
            return null;
        }
    }
}

