/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.http;

import androidx.annotation.NonNull;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.List;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;

public class CallMetricsListener
extends EventListener {
    private long dnsStartTimestamp;
    private long dnsStartTime;
    private long dnsLookupTookTime;
    private long connectStartTimestamp;
    private long connectStartTime;
    private long connectTookTime;
    private long secureConnectStartTimestamp;
    private long secureConnectStartTime;
    private long secureConnectTookTime;
    private long writeRequestHeaderStartTimestamp;
    private long writeRequestHeaderStartTime;
    private long writeRequestHeaderTookTime;
    private long writeRequestBodyStartTimestamp;
    private long writeRequestBodyStartTime;
    private long writeRequestBodyTookTime;
    private long readResponseHeaderStartTimestamp;
    private long readResponseHeaderStartTime;
    private long readResponseHeaderTookTime;
    private long readResponseBodyStartTimestamp;
    private long readResponseBodyStartTime;
    private long readResponseBodyTookTime;
    private List<InetAddress> dnsInetAddressList;
    private InetAddress connectAddress;
    private long requestBodyByteCount;
    private long responseBodyByteCount;

    public CallMetricsListener(Call call) {
    }

    public void dnsStart(Call call, String domainName) {
        super.dnsStart(call, domainName);
        this.dnsStartTime = System.nanoTime();
        this.dnsStartTimestamp = System.currentTimeMillis();
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        super.dnsEnd(call, domainName, inetAddressList);
        StringBuffer ipList = new StringBuffer("{");
        if (inetAddressList != null) {
            for (InetAddress inetAddress : inetAddressList) {
                ipList.append(inetAddress.getHostAddress()).append(",");
            }
        }
        ipList.append("}");
        QCloudLogger.i("QCloudHttp", "dns: " + domainName + ":" + ipList.toString(), new Object[0]);
        this.dnsLookupTookTime += System.nanoTime() - this.dnsStartTime;
        this.dnsInetAddressList = inetAddressList;
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        super.connectStart(call, inetSocketAddress, proxy);
        this.connectStartTime = System.nanoTime();
        this.connectStartTimestamp = System.currentTimeMillis();
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol) {
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
        this.connectTookTime += System.nanoTime() - this.connectStartTime;
        if (inetSocketAddress != null) {
            this.connectAddress = inetSocketAddress.getAddress();
        }
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, Protocol protocol, IOException ioe) {
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
        this.connectTookTime += System.nanoTime() - this.connectStartTime;
        if (inetSocketAddress != null) {
            this.connectAddress = inetSocketAddress.getAddress();
        }
    }

    public void secureConnectStart(Call call) {
        super.secureConnectStart(call);
        this.secureConnectStartTime = System.nanoTime();
        this.secureConnectStartTimestamp = System.currentTimeMillis();
    }

    public void secureConnectEnd(Call call, Handshake handshake) {
        super.secureConnectEnd(call, handshake);
        this.secureConnectTookTime += System.nanoTime() - this.secureConnectStartTime;
    }

    public void requestHeadersStart(Call call) {
        super.requestHeadersStart(call);
        this.writeRequestHeaderStartTime = System.nanoTime();
        this.writeRequestHeaderStartTimestamp = System.currentTimeMillis();
    }

    public void requestHeadersEnd(Call call, Request request) {
        super.requestHeadersEnd(call, request);
        this.writeRequestHeaderTookTime += System.nanoTime() - this.writeRequestHeaderStartTime;
    }

    public void requestBodyStart(Call call) {
        super.requestBodyStart(call);
        this.writeRequestBodyStartTime = System.nanoTime();
        this.writeRequestBodyStartTimestamp = System.currentTimeMillis();
    }

    public void requestBodyEnd(Call call, long byteCount) {
        super.requestBodyEnd(call, byteCount);
        this.writeRequestBodyTookTime += System.nanoTime() - this.writeRequestBodyStartTime;
        this.requestBodyByteCount = byteCount;
    }

    public void responseHeadersStart(Call call) {
        super.responseHeadersStart(call);
        this.readResponseHeaderStartTime = System.nanoTime();
        this.readResponseHeaderStartTimestamp = System.currentTimeMillis();
    }

    public void responseHeadersEnd(Call call, Response response) {
        super.responseHeadersEnd(call, response);
        this.readResponseHeaderTookTime += System.nanoTime() - this.readResponseHeaderStartTime;
    }

    public void responseBodyStart(Call call) {
        super.responseBodyStart(call);
        this.readResponseBodyStartTime = System.nanoTime();
        this.readResponseBodyStartTimestamp = System.currentTimeMillis();
    }

    public void responseBodyEnd(Call call, long byteCount) {
        super.responseBodyEnd(call, byteCount);
        this.readResponseBodyTookTime += System.nanoTime() - this.readResponseBodyStartTime;
        this.responseBodyByteCount = byteCount;
    }

    public void dumpMetrics(HttpTaskMetrics metrics) {
        metrics.recordConnectAddress(this.connectAddress);
        metrics.remoteAddress = this.dnsInetAddressList;
        metrics.dnsStartTimestamp += this.dnsStartTimestamp;
        metrics.dnsLookupTookTime += this.dnsLookupTookTime;
        metrics.connectStartTimestamp += this.connectStartTimestamp;
        metrics.connectTookTime += this.connectTookTime;
        metrics.secureConnectStartTimestamp += this.secureConnectStartTimestamp;
        metrics.secureConnectTookTime += this.secureConnectTookTime;
        metrics.writeRequestHeaderStartTimestamp += this.writeRequestHeaderStartTimestamp;
        metrics.writeRequestHeaderTookTime += this.writeRequestHeaderTookTime;
        metrics.writeRequestBodyStartTimestamp += this.writeRequestBodyStartTimestamp;
        metrics.writeRequestBodyTookTime += this.writeRequestBodyTookTime;
        metrics.readResponseHeaderStartTimestamp += this.readResponseHeaderStartTimestamp;
        metrics.readResponseHeaderTookTime += this.readResponseHeaderTookTime;
        metrics.readResponseBodyStartTimestamp += this.readResponseBodyStartTimestamp;
        metrics.readResponseBodyTookTime += this.readResponseBodyTookTime;
        metrics.requestBodyByteCount = this.requestBodyByteCount;
        metrics.responseBodyByteCount = this.responseBodyByteCount;
    }

    public List<InetAddress> dumpDns() {
        return this.dnsInetAddressList;
    }

    @NonNull
    public String toString() {
        return "CallMetricsListener{dnsStartTimestamp=" + this.dnsStartTimestamp + ", dnsLookupTookTime=" + this.dnsLookupTookTime + ", connectTimestamp=" + this.connectStartTimestamp + ", connectTookTime=" + this.connectTookTime + ", secureConnectTimestamp=" + this.secureConnectStartTimestamp + ", secureConnectTookTime=" + this.secureConnectTookTime + ", writeRequestHeaderTimestamp=" + this.writeRequestHeaderStartTimestamp + ", writeRequestHeaderTookTime=" + this.writeRequestHeaderTookTime + ", writeRequestBodyTimestamp=" + this.writeRequestBodyStartTimestamp + ", writeRequestBodyTookTime=" + this.writeRequestBodyTookTime + ", readResponseHeaderTimestamp=" + this.readResponseHeaderStartTimestamp + ", readResponseHeaderTookTime=" + this.readResponseHeaderTookTime + ", readResponseBodyTimestamp=" + this.readResponseBodyStartTimestamp + ", readResponseBodyTookTime=" + this.readResponseBodyTookTime + ", inetAddressList=" + this.dnsInetAddressList + ", connectAddress=" + this.connectAddress + ", requestBodyByteCount=" + this.requestBodyByteCount + ", responseBodyByteCount=" + this.responseBodyByteCount + '}';
    }
}

