/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.core.auth;

import com.tencent.qcloud.core.auth.QCloudCredentials;
import java.util.Date;

public class OAuth2Credentials
implements QCloudCredentials {
    private String platform;
    private String accessToken;
    private Date validFromDate;
    private Date tokenStartTime;
    private String refreshToken;
    private String openId;
    private String scope;
    private String authorizationCode;

    private OAuth2Credentials(Builder builder) {
        this.platform = builder.platform;
        this.accessToken = builder.accessToken;
        this.tokenStartTime = new Date(builder.tokenStartTime);
        this.validFromDate = new Date(builder.tokenStartTime + builder.expiresIn * 1000L);
        this.refreshToken = builder.refreshToken;
        this.openId = builder.openId;
        this.scope = builder.scope;
        this.authorizationCode = builder.authorizationCode;
    }

    public String getPlatform() {
        return this.platform;
    }

    @Override
    public String getSecretId() {
        return this.openId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getOpenId() {
        return this.openId;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.validFromDate.getTime();
    }

    public long getExpiresInSeconds() {
        return (this.validFromDate.getTime() - this.tokenStartTime.getTime()) / 1000L;
    }

    public Date getValidFromDate() {
        return this.validFromDate;
    }

    public Date getTokenStartTime() {
        return this.tokenStartTime;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public static final class Builder {
        private String platform;
        private String accessToken;
        private long expiresIn;
        private long tokenStartTime;
        private String refreshToken;
        private String openId;
        private String scope;
        private String authorizationCode;

        public Builder platform(String val) {
            this.platform = val;
            return this;
        }

        public Builder accessToken(String val) {
            this.accessToken = val;
            return this;
        }

        public Builder expiresInSeconds(long val) {
            this.expiresIn = val;
            return this;
        }

        public Builder tokenStartTime(long val) {
            this.tokenStartTime = val;
            return this;
        }

        public Builder refreshToken(String val) {
            this.refreshToken = val;
            return this;
        }

        public Builder openId(String val) {
            this.openId = val;
            return this;
        }

        public Builder authorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public Builder scope(String val) {
            this.scope = val;
            return this;
        }

        public OAuth2Credentials build() {
            return new OAuth2Credentials(this);
        }
    }
}

