/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.text.TextUtils;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.transfer.BaseUploadPartsTask;
import com.tencent.cos.xml.transfer.COSTransferTask;
import com.tencent.cos.xml.transfer.COSUploadTask;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import java.util.Set;

class SerialUploadPartsTask
extends BaseUploadPartsTask {
    private long mStartPointer;
    private int mPartNumber;
    private volatile HttpTaskMetrics httpTaskMetrics;
    private UploadPartRequest currentUploadPartRequest;

    public SerialUploadPartsTask(COSDirect cosDirect, PutObjectRequest putObjectRequest, long offset, long size, int startPartNumber, String uploadId) {
        super(cosDirect, putObjectRequest, offset, size, startPartNumber, uploadId);
    }

    @Override
    public Set<COSUploadTask.UploadPart> upload() throws CosXmlClientException, CosXmlServiceException {
        this.mStartPointer = this.mOffset;
        this.mPartNumber = this.mStartNumber;
        while (this.mStartPointer < this.mOffset + this.mSize) {
            long partSize = Math.min(this.mMaxPartSize, this.mOffset + this.mSize - this.mStartPointer);
            this.currentUploadPartRequest = this.getUploadRequest(this.mPartNumber, this.mStartPointer, partSize);
            this.currentUploadPartRequest.setProgressListener(new CosXmlProgressListener(){

                public void onProgress(long complete, long target) {
                    SerialUploadPartsTask.this.notifyProgressChange(SerialUploadPartsTask.this.mStartPointer + complete, SerialUploadPartsTask.this.mOffset + SerialUploadPartsTask.this.mSize);
                }
            });
            UploadPartResult uploadPartResult = this.mCosDirect.uploadPart(this.currentUploadPartRequest);
            String etag = uploadPartResult.eTag;
            COSTransferTask.loggerInfo("QCloudUpload", this.taskId, "upload part %d, etag=%s", this.mPartNumber, etag);
            if (TextUtils.isEmpty((CharSequence)etag)) {
                throw new CosXmlClientException(ClientErrorCode.ETAG_NOT_FOUND);
            }
            COSUploadTask.UploadPart uploadPart = new COSUploadTask.UploadPart(etag, this.mPartNumber, this.mStartPointer, partSize);
            this.mStartPointer += partSize;
            ++this.mPartNumber;
            this.uploadParts.add(uploadPart);
        }
        return this.uploadParts;
    }

    @Override
    public void cancel() {
        if (this.currentUploadPartRequest != null) {
            this.mCosDirect.cancel((CosXmlRequest)this.currentUploadPartRequest);
        }
    }

    @Override
    public void cancel(boolean now) {
        if (this.currentUploadPartRequest != null) {
            this.mCosDirect.cancel((CosXmlRequest)this.currentUploadPartRequest, now);
        }
    }

    public void setHttpTaskMetrics(HttpTaskMetrics httpTaskMetrics) {
        this.httpTaskMetrics = httpTaskMetrics;
    }

    private synchronized void mergeTaskMetrics(HttpTaskMetrics httpTaskMetrics) {
        if (httpTaskMetrics != null && this.httpTaskMetrics != null) {
            this.httpTaskMetrics.merge(httpTaskMetrics);
        }
    }
}

