/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import androidx.annotation.Nullable;
import com.tencent.cos.xml.BeaconService;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.transfer.InitMultipleUploadListener;
import com.tencent.cos.xml.transfer.TaskStateMonitor;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.TransferStateListener;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class COSXMLTask {
    private static final String TAG = "COSXMLTask";
    protected static TaskStateMonitor monitor = TaskStateMonitor.getInstance();
    protected CosXmlSimpleService cosXmlService;
    protected String region;
    protected String bucket;
    protected String cosPath;
    protected CosXmlResult mResult;
    protected Exception mException;
    protected Map<String, String> queries;
    protected Map<String, List<String>> headers;
    protected boolean isNeedMd5 = true;
    protected CosXmlProgressListener cosXmlProgressListener;
    protected CosXmlResultListener cosXmlResultListener;
    protected TransferStateListener transferStateListener;
    protected InitMultipleUploadListener initMultipleUploadListener;
    protected TransferStateListener internalStateListener;
    protected CosXmlProgressListener internalProgressListener;
    protected InitMultipleUploadListener internalInitMultipleUploadListener;
    volatile TransferState taskState = TransferState.WAITING;
    protected AtomicBoolean IS_EXIT = new AtomicBoolean(false);
    protected OnSignatureListener onSignatureListener;
    protected OnGetHttpTaskMetrics onGetHttpTaskMetrics;
    protected Timer waitTimeoutTimer;
    private boolean isCancelNow;

    protected void setCosXmlService(CosXmlSimpleService cosXmlService) {
        this.cosXmlService = cosXmlService;
    }

    public void setCosXmlProgressListener(CosXmlProgressListener cosXmlProgressListener) {
        this.cosXmlProgressListener = cosXmlProgressListener;
    }

    public void setCosXmlResultListener(CosXmlResultListener cosXmlResultListener) {
        this.cosXmlResultListener = cosXmlResultListener;
        monitor.sendStateMessage(this, null, this.mException, this.mResult, 4);
    }

    public void setTransferStateListener(TransferStateListener transferStateListener) {
        this.transferStateListener = transferStateListener;
        monitor.sendStateMessage(this, this.taskState, null, null, 4);
    }

    public void setInitMultipleUploadListener(InitMultipleUploadListener initMultipleUploadListener) {
        this.initMultipleUploadListener = initMultipleUploadListener;
    }

    public void setOnSignatureListener(OnSignatureListener onSignatureListener) {
        this.onSignatureListener = onSignatureListener;
    }

    public void setOnGetHttpTaskMetrics(OnGetHttpTaskMetrics onGetHttpTaskMetrics) {
        this.onGetHttpTaskMetrics = onGetHttpTaskMetrics;
    }

    protected void getHttpMetrics(CosXmlRequest cosXmlRequest, String requestName) {
        cosXmlRequest.attachMetrics((HttpTaskMetrics)new COSXMLMetrics(requestName));
    }

    public void startTimeoutTimer(long millisecond) {
        this.waitTimeoutTimer = new Timer();
        this.waitTimeoutTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (COSXMLTask.this.taskState == TransferState.WAITING || COSXMLTask.this.taskState == TransferState.RESUMED_WAITING) {
                    COSXMLTask.this.encounterError(null, new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), "Task waiting timeout."), null);
                }
            }
        }, millisecond);
    }

    protected void internalCompleted() {
    }

    protected void internalFailed() {
    }

    protected void internalPause() {
    }

    protected void internalCancel(boolean now) {
    }

    protected void internalResume() {
    }

    protected abstract void encounterError(@Nullable CosXmlRequest var1, CosXmlClientException var2, CosXmlServiceException var3);

    public void pause() {
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        monitor.sendStateMessage(this, TransferState.PAUSED, null, null, 2);
    }

    public void cancel() {
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        monitor.sendStateMessage(this, TransferState.CANCELED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.USER_CANCELLED.getCode(), "canceled by user")), null, 2);
    }

    public void cancel(boolean now) {
        this.isCancelNow = now;
        if (this.IS_EXIT.get()) {
            return;
        }
        this.IS_EXIT.set(true);
        monitor.sendStateMessage(this, TransferState.CANCELED, (Exception)((Object)new CosXmlClientException(ClientErrorCode.USER_CANCELLED.getCode(), "canceled by user")), null, 2);
    }

    public void resume() {
        monitor.sendStateMessage(this, TransferState.RESUMED_WAITING, null, null, 2);
    }

    public TransferState getTaskState() {
        return this.taskState;
    }

    public CosXmlResult getResult() {
        return this.mResult;
    }

    public Exception getException() {
        return this.mException;
    }

    protected abstract CosXmlRequest buildCOSXMLTaskRequest();

    public void clearResultAndException() {
        this.mException = null;
        this.mResult = null;
    }

    protected abstract CosXmlResult buildCOSXMLTaskResult(CosXmlResult var1);

    private void dispatchStateChange(TransferState transferState) {
        if (this.transferStateListener != null) {
            this.transferStateListener.onStateChanged(transferState);
        }
        if (this.internalStateListener != null) {
            this.internalStateListener.onStateChanged(transferState);
        }
    }

    protected synchronized void updateState(TransferState newTaskState, Exception exception, CosXmlResult result, boolean isInit) {
        if (isInit) {
            if (exception != null) {
                if (this.cosXmlResultListener != null) {
                    if (exception instanceof CosXmlClientException) {
                        this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(), (CosXmlClientException)((Object)exception), null);
                    } else {
                        this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(), null, (CosXmlServiceException)((Object)exception));
                    }
                }
            } else if (result != null) {
                if (this.cosXmlResultListener != null) {
                    this.cosXmlResultListener.onSuccess(this.buildCOSXMLTaskRequest(), result);
                }
            } else if (newTaskState != null) {
                this.dispatchStateChange(this.taskState);
            }
            return;
        }
        switch (newTaskState) {
            case WAITING: {
                if (this.taskState != TransferState.RESUMED_WAITING) break;
                this.taskState = TransferState.WAITING;
                this.dispatchStateChange(this.taskState);
                break;
            }
            case IN_PROGRESS: {
                if (this.taskState != TransferState.WAITING) break;
                this.taskState = TransferState.IN_PROGRESS;
                this.dispatchStateChange(this.taskState);
                break;
            }
            case COMPLETED: {
                if (this.taskState != TransferState.IN_PROGRESS) break;
                this.taskState = TransferState.COMPLETED;
                this.mResult = this.buildCOSXMLTaskResult(result);
                if (this.cosXmlResultListener != null) {
                    this.cosXmlResultListener.onSuccess(this.buildCOSXMLTaskRequest(), this.mResult);
                }
                this.dispatchStateChange(this.taskState);
                this.internalCompleted();
                break;
            }
            case FAILED: {
                if (this.taskState != TransferState.WAITING && this.taskState != TransferState.IN_PROGRESS) break;
                this.taskState = TransferState.FAILED;
                this.mException = exception;
                if (this.cosXmlResultListener != null) {
                    if (exception instanceof CosXmlClientException) {
                        this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(), (CosXmlClientException)((Object)exception), null);
                    } else {
                        this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(), null, (CosXmlServiceException)((Object)exception));
                    }
                }
                this.dispatchStateChange(this.taskState);
                this.internalFailed();
                break;
            }
            case PAUSED: {
                if (this.taskState != TransferState.WAITING && this.taskState != TransferState.IN_PROGRESS) break;
                this.taskState = TransferState.PAUSED;
                this.dispatchStateChange(this.taskState);
                this.internalPause();
                break;
            }
            case CANCELED: {
                if (this.taskState == TransferState.CANCELED || this.taskState == TransferState.COMPLETED) break;
                this.taskState = TransferState.CANCELED;
                this.dispatchStateChange(this.taskState);
                this.mException = exception;
                if (this.cosXmlResultListener != null) {
                    this.cosXmlResultListener.onFail(this.buildCOSXMLTaskRequest(), (CosXmlClientException)((Object)exception), null);
                }
                this.internalCancel(this.isCancelNow);
                break;
            }
            case RESUMED_WAITING: {
                if (this.taskState != TransferState.PAUSED && this.taskState != TransferState.FAILED && this.taskState != TransferState.CONSTRAINED) break;
                this.taskState = TransferState.RESUMED_WAITING;
                this.dispatchStateChange(this.taskState);
                this.internalResume();
                break;
            }
            default: {
                IllegalStateException illegalStateException = new IllegalStateException("invalid state: " + (Object)((Object)newTaskState));
                BeaconService.getInstance().reportError(TAG, (Exception)illegalStateException);
                throw illegalStateException;
            }
        }
    }

    void setInternalStateListener(TransferStateListener internalStateListener) {
        this.internalStateListener = internalStateListener;
    }

    void setInternalProgressListener(CosXmlProgressListener internalProgressListener) {
        this.internalProgressListener = internalProgressListener;
    }

    void setInternalInitMultipleUploadListener(InitMultipleUploadListener internalInitMultipleUploadListener) {
        this.internalInitMultipleUploadListener = internalInitMultipleUploadListener;
    }

    public static interface OnGetHttpTaskMetrics {
        public void onGetHttpMetrics(String var1, HttpTaskMetrics var2);
    }

    @Deprecated
    public static interface OnSignatureListener {
        public String onGetSign(CosXmlRequest var1);
    }

    class COSXMLMetrics
    extends HttpTaskMetrics {
        String requestName;

        COSXMLMetrics(String requestName) {
            this.requestName = requestName;
        }

        public void onDataReady() {
            super.onDataReady();
            if (COSXMLTask.this.onGetHttpTaskMetrics != null) {
                COSXMLTask.this.onGetHttpTaskMetrics.onGetHttpMetrics(this.requestName, this);
            }
        }
    }
}

