/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.tag.eventstreaming;

import android.util.Xml;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.tag.eventstreaming.HeaderType;
import com.tencent.cos.xml.model.tag.eventstreaming.HeaderValue;
import com.tencent.cos.xml.model.tag.eventstreaming.Message;
import com.tencent.cos.xml.model.tag.eventstreaming.Progress;
import com.tencent.cos.xml.model.tag.eventstreaming.SelectObjectContentEvent;
import com.tencent.cos.xml.model.tag.eventstreaming.SelectObjectContentEventException;
import com.tencent.cos.xml.model.tag.eventstreaming.Stats;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class SelectObjectContentEventUnmarshaller {
    public static SelectObjectContentEvent unmarshalMessage(Message message) throws CosXmlServiceException {
        String messageType = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":message-type");
        if ("error".equals(messageType)) {
            throw SelectObjectContentEventUnmarshaller.unmarshalErrorMessage(message);
        }
        if ("event".equals(messageType)) {
            return SelectObjectContentEventUnmarshaller.unmarshalEventMessage(message);
        }
        throw new CosXmlServiceException("Service returned unknown message type: " + messageType);
    }

    private static CosXmlServiceException unmarshalErrorMessage(Message message) throws CosXmlServiceException {
        String errorCode = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":error-code");
        String errorMessage = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":error-message");
        SelectObjectContentEventException exception = new SelectObjectContentEventException("S3 returned an error: " + errorMessage + " (" + errorCode + ")");
        exception.setErrorCode(errorCode);
        exception.setErrorMessage(errorMessage);
        return new CosXmlServiceException("Select object content error event", (Exception)exception);
    }

    private static SelectObjectContentEvent unmarshalEventMessage(Message message) throws CosXmlServiceException {
        String eventType = SelectObjectContentEventUnmarshaller.getStringHeader(message, ":event-type");
        try {
            return SelectObjectContentEventUnmarshaller.forEventType(eventType).unmarshal(message);
        }
        catch (Exception e2) {
            throw new CosXmlServiceException("Failed to read response event of type " + eventType, e2);
        }
    }

    public static SelectObjectContentEventUnmarshaller forEventType(String eventType) {
        if ("Records".equals(eventType)) {
            return new RecordsEventUnmarshaller();
        }
        if ("Stats".equals(eventType)) {
            return new StatsEventUnmarshaller();
        }
        if ("Progress".equals(eventType)) {
            return new ProgressEventUnmarshaller();
        }
        if ("Cont".equals(eventType)) {
            return new ContinuationEventUnmarshaller();
        }
        if ("End".equals(eventType)) {
            return new EndEventUnmarshaller();
        }
        return new UnknownEventUnmarshaller();
    }

    private static String getStringHeader(Message message, String headerName) throws CosXmlServiceException {
        HeaderValue header = message.getHeaders().get(headerName);
        if (header == null) {
            throw new CosXmlServiceException("Unexpected lack of '" + headerName + "' header from service.");
        }
        if (header.getType() != HeaderType.STRING) {
            throw new CosXmlServiceException("Unexpected non-string '" + headerName + "' header: " + (Object)((Object)header.getType()));
        }
        return header.getString();
    }

    public abstract SelectObjectContentEvent unmarshal(Message var1) throws Exception;

    private static Stats parsePayloadStats(Message message) throws XmlPullParserException, IOException {
        long[] progress = SelectObjectContentEventUnmarshaller.parsePayloadBytesProgress(message);
        return new Stats(progress[0], progress[1], progress[2]);
    }

    private static Progress parsePayloadProgress(Message message) throws XmlPullParserException, IOException {
        long[] progress = SelectObjectContentEventUnmarshaller.parsePayloadBytesProgress(message);
        return new Progress(progress[0], progress[1], progress[2]);
    }

    private static long[] parsePayloadBytesProgress(Message message) throws XmlPullParserException, IOException {
        XmlPullParser xmlPullParser = Xml.newPullParser();
        xmlPullParser.setInput((InputStream)new ByteArrayInputStream(message.getPayload()), "UTF-8");
        int eventType = xmlPullParser.getEventType();
        long bytesScanned = 0L;
        long bytesProcessed = 0L;
        long bytesReturned = 0L;
        while (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String tagName = xmlPullParser.getName();
                    if (tagName.equalsIgnoreCase("BytesScanned")) {
                        xmlPullParser.next();
                        bytesScanned = Long.parseLong(xmlPullParser.getText());
                        break;
                    }
                    if (tagName.equalsIgnoreCase("BytesProcessed")) {
                        xmlPullParser.next();
                        bytesProcessed = Long.parseLong(xmlPullParser.getText());
                        break;
                    }
                    if (!tagName.equalsIgnoreCase("BytesReturned")) break;
                    xmlPullParser.next();
                    bytesReturned = Long.parseLong(xmlPullParser.getText());
                }
            }
            eventType = xmlPullParser.next();
        }
        return new long[]{bytesScanned, bytesProcessed, bytesReturned};
    }

    public static class UnknownEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent unmarshal(Message message) {
            return new SelectObjectContentEvent();
        }
    }

    public static class EndEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.EndEvent unmarshal(Message message) {
            return new SelectObjectContentEvent.EndEvent();
        }
    }

    public static class ContinuationEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.ContinuationEvent unmarshal(Message message) {
            return new SelectObjectContentEvent.ContinuationEvent();
        }
    }

    public static class ProgressEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.ProgressEvent unmarshal(Message message) throws Exception {
            Progress progress = SelectObjectContentEventUnmarshaller.parsePayloadProgress(message);
            return new SelectObjectContentEvent.ProgressEvent().withDetails(progress);
        }
    }

    public static class StatsEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.StatsEvent unmarshal(Message message) throws Exception {
            Stats stats = SelectObjectContentEventUnmarshaller.parsePayloadStats(message);
            return new SelectObjectContentEvent.StatsEvent().withDetails(stats);
        }
    }

    public static class RecordsEventUnmarshaller
    extends SelectObjectContentEventUnmarshaller {
        @Override
        public SelectObjectContentEvent.RecordsEvent unmarshal(Message message) {
            return new SelectObjectContentEvent.RecordsEvent().withPayload(ByteBuffer.wrap(message.getPayload()));
        }
    }
}

