/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import androidx.annotation.NonNull;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.bucket.BucketRequest;
import com.tencent.cos.xml.model.tag.RefererConfiguration;
import com.tencent.cos.xml.utils.QCloudXmlUtils;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PutBucketRefererRequest
extends BucketRequest {
    private final RefererConfiguration refererConfiguration = new RefererConfiguration();

    public PutBucketRefererRequest(String bucket, boolean enabled, RefererConfiguration.RefererType refererType) {
        super(bucket);
        this.refererConfiguration.setEnabled(enabled);
        this.refererConfiguration.setRefererType(refererType);
        this.refererConfiguration.setAllowEmptyRefer(false);
        this.refererConfiguration.domainList = new ArrayList<RefererConfiguration.Domain>();
    }

    public void setEnabled(boolean enabled) {
        this.refererConfiguration.setEnabled(enabled);
    }

    public void setRefererType(@NonNull RefererConfiguration.RefererType refererType) {
        this.refererConfiguration.setRefererType(refererType);
    }

    public void setAllowEmptyRefer(boolean allowEmptyRefer) {
        this.refererConfiguration.setAllowEmptyRefer(allowEmptyRefer);
    }

    public void setDomainList(@NonNull List<RefererConfiguration.Domain> domains) {
        this.refererConfiguration.domainList = domains;
    }

    public String getMethod() {
        return "PUT";
    }

    public Map<String, String> getQueryString() {
        this.queryParameters.put("referer", null);
        return super.getQueryString();
    }

    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        return RequestBodySerializer.string((String)"application/xml", (String)QCloudXmlUtils.toXml((Object)this.refererConfiguration));
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.refererConfiguration.domainList == null || this.refererConfiguration.domainList.size() <= 0) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "DomainList must not be null");
        }
    }

    public boolean isNeedMD5() {
        return true;
    }
}

