/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import android.text.TextUtils;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.bucket.BucketRequest;
import com.tencent.cos.xml.model.tag.InventoryConfiguration;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParserException;

public class PutBucketInventoryRequest
extends BucketRequest {
    private static Pattern pattern = Pattern.compile("[a-zA-Z0-9-_.]+");
    private InventoryConfiguration inventoryConfiguration = new InventoryConfiguration();

    public PutBucketInventoryRequest(String bucket) {
        super(bucket);
        this.inventoryConfiguration.isEnabled = true;
        this.inventoryConfiguration.id = "None";
        this.inventoryConfiguration.schedule = new InventoryConfiguration.Schedule();
        this.inventoryConfiguration.destination = new InventoryConfiguration.Destination();
        this.inventoryConfiguration.destination.cosBucketDestination = new InventoryConfiguration.COSBucketDestination();
    }

    public void setInventoryId(String inventoryId) {
        this.inventoryConfiguration.id = inventoryId;
    }

    public void isEnable(boolean isEnabled) {
        this.inventoryConfiguration.isEnabled = isEnabled;
    }

    public void setFilter(String prefix) {
        if (!TextUtils.isEmpty((CharSequence)prefix)) {
            this.inventoryConfiguration.filter = new InventoryConfiguration.Filter();
            this.inventoryConfiguration.filter.prefix = prefix;
        }
    }

    public void setDestination(String format, String accountId, String bucket, String region, String prefix) {
        if (format != null) {
            this.inventoryConfiguration.destination.cosBucketDestination.format = format;
        }
        if (accountId != null) {
            this.inventoryConfiguration.destination.cosBucketDestination.accountId = accountId;
        }
        if (bucket != null && region != null) {
            this.inventoryConfiguration.destination.cosBucketDestination.bucket = "qcs::cos:" + region + "::" + bucket;
        }
        if (prefix != null) {
            this.inventoryConfiguration.destination.cosBucketDestination.prefix = prefix;
        }
        this.inventoryConfiguration.destination.cosBucketDestination.encryption = new InventoryConfiguration.Encryption();
        this.inventoryConfiguration.destination.cosBucketDestination.encryption.sSECOS = "";
    }

    public void setScheduleFrequency(String frequency) {
        if (frequency != null) {
            this.inventoryConfiguration.schedule.frequency = frequency;
        }
    }

    public void setOptionalFields(InventoryConfiguration.Field field) {
        if (field != null) {
            if (this.inventoryConfiguration.optionalFields == null) {
                this.inventoryConfiguration.optionalFields = new InventoryConfiguration.OptionalFields();
                this.inventoryConfiguration.optionalFields.fields = new HashSet<String>(6);
            }
            this.inventoryConfiguration.optionalFields.fields.add(field.getValue());
        }
    }

    public void setIncludedObjectVersions(InventoryConfiguration.IncludedObjectVersions includedObjectVersions) {
        if (includedObjectVersions != null) {
            this.inventoryConfiguration.includedObjectVersions = includedObjectVersions.getDesc();
        }
    }

    public String getMethod() {
        return "PUT";
    }

    public Map<String, String> getQueryString() {
        this.queryParameters.put("inventory", null);
        this.queryParameters.put("id", this.inventoryConfiguration.id);
        return super.getQueryString();
    }

    protected RequestBodySerializer xmlBuilder() throws XmlPullParserException, IOException {
        return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildInventoryConfiguration(this.inventoryConfiguration));
    }

    public boolean isNeedMD5() {
        return true;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.inventoryConfiguration.id == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "inventoryId == null");
        }
        Matcher matcher = pattern.matcher(this.inventoryConfiguration.id);
        if (!matcher.find()) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "inventoryId must be in [a-zA-Z0-9-_.]");
        }
        if (this.inventoryConfiguration.includedObjectVersions == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "includedObjectVersions == null");
        }
        if (this.inventoryConfiguration.schedule.frequency == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "schedule.frequency == null");
        }
        if (this.inventoryConfiguration.destination.cosBucketDestination.bucket == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosBucketDestination.bucket == null");
        }
        if (this.inventoryConfiguration.destination.cosBucketDestination.format == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosBucketDestination.format == null");
        }
    }
}

