/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.cos.xml.CosXmlBaseService;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.SimpleCosXml;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.listener.CosXmlResultSimpleListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsRequest;
import com.tencent.cos.xml.model.bucket.ListMultiUploadsResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.AbortMultiUploadResult;
import com.tencent.cos.xml.model.object.AppendObjectRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.CopyObjectResult;
import com.tencent.cos.xml.model.object.DeleteObjectRequest;
import com.tencent.cos.xml.model.object.DeleteObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PostObjectRequest;
import com.tencent.cos.xml.model.object.PostObjectResult;
import com.tencent.cos.xml.model.object.PreBuildConnectionRequest;
import com.tencent.cos.xml.model.object.PreBuildConnectionResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartCopyRequest;
import com.tencent.cos.xml.model.object.UploadPartCopyResult;
import com.tencent.qcloud.core.auth.QCloudCredentialProvider;
import com.tencent.qcloud.core.auth.QCloudSelfSigner;
import com.tencent.qcloud.core.auth.QCloudSigner;
import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.http.HttpTask;

public class CosXmlSimpleService
extends CosXmlBaseService
implements SimpleCosXml {
    private static final String TAG = "CosXmlSimpleService";

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudCredentialProvider qCloudCredentialProvider) {
        super(context, configuration, qCloudCredentialProvider);
    }

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration) {
        super(context, configuration);
    }

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudSigner qCloudSigner) {
        super(context, configuration, qCloudSigner);
    }

    public CosXmlSimpleService(Context context, CosXmlServiceConfig configuration, QCloudSelfSigner selfSigner) {
        super(context, configuration, selfSigner);
    }

    protected <T1 extends CosXmlRequest> void setCopySource(T1 cosXmlRequest) throws CosXmlClientException {
        super.setCopySource(cosXmlRequest);
        if (cosXmlRequest instanceof CopyObjectRequest) {
            ((CopyObjectRequest)cosXmlRequest).setCopySource(((CopyObjectRequest)cosXmlRequest).getCopySource(), this.config);
        }
    }

    protected <T1 extends CosXmlRequest, T2 extends CosXmlResult> void setProgressListener(T1 cosXmlRequest, HttpTask<T2> httpTask, boolean isSchedule) {
        super.setProgressListener(cosXmlRequest, httpTask, isSchedule);
        if (cosXmlRequest instanceof AppendObjectRequest) {
            httpTask.addProgressListener((QCloudProgressListener)((AppendObjectRequest)cosXmlRequest).getProgressListener());
        } else if (cosXmlRequest instanceof PostObjectRequest) {
            httpTask.addProgressListener((QCloudProgressListener)((PostObjectRequest)cosXmlRequest).getProgressListener());
        }
    }

    @Override
    public PutObjectResult putObject(PutObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl((CosXmlRequest)request);
        return (PutObjectResult)this.execute((CosXmlRequest)request, (CosXmlResult)putObjectResult);
    }

    @Override
    public void putObjectAsync(PutObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PutObjectResult putObjectResult = new PutObjectResult();
        putObjectResult.accessUrl = this.getAccessUrl((CosXmlRequest)request);
        this.schedule((CosXmlRequest)request, (CosXmlResult)putObjectResult, cosXmlResultListener);
    }

    @Override
    public PostObjectResult postObject(PostObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        PostObjectResult postObjectResult = new PostObjectResult();
        return (PostObjectResult)this.execute((CosXmlRequest)request, postObjectResult);
    }

    @Override
    public void postObjectAsync(PostObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        PostObjectResult postObjectResult = new PostObjectResult();
        this.schedule((CosXmlRequest)request, postObjectResult, cosXmlResultListener);
    }

    @Override
    public DeleteObjectResult deleteObject(DeleteObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (DeleteObjectResult)this.execute((CosXmlRequest)request, new DeleteObjectResult());
    }

    @Override
    public void deleteObjectAsync(DeleteObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule((CosXmlRequest)request, new DeleteObjectResult(), cosXmlResultListener);
    }

    @Override
    public HeadObjectResult headObject(HeadObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        HeadObjectResult headObjectResult = new HeadObjectResult();
        headObjectResult.accessUrl = this.getAccessUrl((CosXmlRequest)request);
        return (HeadObjectResult)this.execute((CosXmlRequest)request, headObjectResult);
    }

    @Override
    public void headObjectAsync(HeadObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        HeadObjectResult headObjectResult = new HeadObjectResult();
        headObjectResult.accessUrl = this.getAccessUrl((CosXmlRequest)request);
        this.schedule((CosXmlRequest)request, headObjectResult, cosXmlResultListener);
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (CopyObjectResult)this.execute((CosXmlRequest)request, new CopyObjectResult());
    }

    @Override
    public void copyObjectAsync(CopyObjectRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule((CosXmlRequest)request, new CopyObjectResult(), cosXmlResultListener);
    }

    @Override
    public UploadPartCopyResult copyObject(UploadPartCopyRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (UploadPartCopyResult)this.execute((CosXmlRequest)request, new UploadPartCopyResult());
    }

    @Override
    public void copyObjectAsync(UploadPartCopyRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule((CosXmlRequest)request, new UploadPartCopyResult(), cosXmlResultListener);
    }

    @Override
    public InitMultipartUploadResult initMultipartUpload(InitMultipartUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (InitMultipartUploadResult)this.execute((CosXmlRequest)request, new InitMultipartUploadResult());
    }

    @Override
    public void initMultipartUploadAsync(InitMultipartUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule((CosXmlRequest)request, new InitMultipartUploadResult(), cosXmlResultListener);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (ListPartsResult)this.execute((CosXmlRequest)request, new ListPartsResult());
    }

    @Override
    public void listPartsAsync(ListPartsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule((CosXmlRequest)request, new ListPartsResult(), cosXmlResultListener);
    }

    @Override
    public AbortMultiUploadResult abortMultiUpload(AbortMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (AbortMultiUploadResult)this.execute((CosXmlRequest)request, new AbortMultiUploadResult());
    }

    @Override
    public void abortMultiUploadAsync(AbortMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule((CosXmlRequest)request, new AbortMultiUploadResult(), cosXmlResultListener);
    }

    @Override
    public CompleteMultiUploadResult completeMultiUpload(CompleteMultiUploadRequest request) throws CosXmlClientException, CosXmlServiceException {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl((CosXmlRequest)request);
        return (CompleteMultiUploadResult)this.execute((CosXmlRequest)request, completeMultiUploadResult);
    }

    @Override
    public void completeMultiUploadAsync(CompleteMultiUploadRequest request, CosXmlResultListener cosXmlResultListener) {
        CompleteMultiUploadResult completeMultiUploadResult = new CompleteMultiUploadResult();
        completeMultiUploadResult.accessUrl = this.getAccessUrl((CosXmlRequest)request);
        this.schedule((CosXmlRequest)request, completeMultiUploadResult, cosXmlResultListener);
    }

    @Override
    public boolean preBuildConnection(String bucket) {
        PreBuildConnectionRequest preBuildConnectionRequest = new PreBuildConnectionRequest(bucket);
        try {
            this.execute(preBuildConnectionRequest, new PreBuildConnectionResult());
            return true;
        }
        catch (CosXmlClientException e2) {
            return false;
        }
        catch (CosXmlServiceException e3) {
            return e3.getStatusCode() != 404;
        }
    }

    @Override
    public void preBuildConnectionAsync(String bucket, final CosXmlResultSimpleListener listener) {
        PreBuildConnectionRequest preBuildConnectionRequest = new PreBuildConnectionRequest(bucket);
        this.schedule(preBuildConnectionRequest, new PreBuildConnectionResult(), new CosXmlResultListener(){

            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                listener.onSuccess();
            }

            public void onFail(CosXmlRequest request, CosXmlClientException clientException, CosXmlServiceException serviceException) {
                if (serviceException != null && serviceException.getStatusCode() != 404) {
                    listener.onSuccess();
                } else {
                    listener.onFail(clientException, serviceException);
                }
            }
        });
    }

    @Override
    public ListMultiUploadsResult listMultiUploads(ListMultiUploadsRequest request) throws CosXmlClientException, CosXmlServiceException {
        return (ListMultiUploadsResult)this.execute(request, new ListMultiUploadsResult());
    }

    @Override
    public void listMultiUploadsAsync(ListMultiUploadsRequest request, CosXmlResultListener cosXmlResultListener) {
        this.schedule(request, new ListMultiUploadsResult(), cosXmlResultListener);
    }
}

