/*
 * Copyright (c) 2010-2020 Tencent Cloud. All rights reserved.
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in all
 *  copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 *  SOFTWARE.
 */

package com.tencent.cos.xml.model.ci.audit;

import com.tencent.qcloud.qcloudxml.annoation.XmlBean;
import com.tencent.qcloud.qcloudxml.annoation.XmlElement;

import java.util.List;

@XmlBean(name = "Response", method = XmlBean.GenerateMethod.FROM)
public class GetStrategyDetailResponse {
    /**
     *请求 ID
     */
    public String requestId;

    /**
     *审核策略的详细信息。
     */
    public Strategy strategy;

    @XmlBean(name = "Strategy", method = XmlBean.GenerateMethod.FROM)
    public static class Strategy {
        /**
         *审核策略的名称。
         */
        public String name;

        /**
         *审核策略的服务类型。
         */
        public String service;

        /**
         *审核策略的BizType值。
         */
        public String bizType;

        /**
         *策略已关联的自定义文本库。
         */
        @XmlElement(ignoreListNote = true, flatListNote = true)
        public List<String> textLibs;

        /**
         *策略已开启的审核标签配置，具体含义与创建审核策略的Request.Labels一致。
         */
        public CreateStrategy.Labels labels;
    }
}
