/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import bolts.CancellationTokenSource;
import bolts.Task;
import bolts.TaskCompletionSource;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.common.Range;
import com.tencent.cos.xml.crypto.COSDirect;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectResult;
import com.tencent.cos.xml.model.object.HeadObjectRequest;
import com.tencent.cos.xml.model.object.HeadObjectResult;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.transfer.COSTransferTask;
import com.tencent.cos.xml.transfer.TransferTaskMetrics;
import com.tencent.cos.xml.utils.DigestUtils;
import com.tencent.cos.xml.utils.FileUtils;
import com.tencent.qcloud.core.http.HttpTaskMetrics;
import com.tencent.qcloud.core.util.ContextHolder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class COSDownloadTask
extends COSTransferTask {
    private static final String TAG = "QCloudDownload";
    public static final String TASK_UNKNOWN_STATUS = "task unknown status";
    private static final int DOWNLOAD_CONCURRENT = 3;
    private static ThreadPoolExecutor downloadTaskExecutor = new ThreadPoolExecutor(3, 3, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new COSTransferTask.TaskThreadFactory("QCloudDownload-", 8));
    private volatile GetObjectRequest mGetObjectRequest;
    private volatile long remoteStart = 0L;
    private volatile long remoteEnd = -1L;
    private SimpleDownloadTask simpleDownloadTask;

    public COSDownloadTask(COSDirect cosDirect, GetObjectRequest getObjectRequest) {
        super(cosDirect, (ObjectRequest)getObjectRequest);
        this.mGetObjectRequest = getObjectRequest;
        Range range = getObjectRequest.getRange();
        if (range != null) {
            this.remoteStart = range.getStart();
            this.remoteEnd = range.getEnd();
        }
    }

    @Override
    protected String tag() {
        return TAG;
    }

    @Override
    protected Executor executor() {
        return downloadTaskExecutor;
    }

    @Override
    public void pause() {
        super.pause();
        if (this.simpleDownloadTask != null) {
            this.simpleDownloadTask.cancel(false);
        }
    }

    @Override
    public void pause(boolean now) {
        super.pause();
        if (this.simpleDownloadTask != null) {
            this.simpleDownloadTask.cancel(now);
        }
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.simpleDownloadTask != null) {
            this.simpleDownloadTask.cancel(false);
        }
        FileUtils.deleteFileIfExist((String)this.mGetObjectRequest.getDownloadPath());
    }

    @Override
    public void cancel(boolean now) {
        super.cancel();
        if (this.simpleDownloadTask != null) {
            this.simpleDownloadTask.cancel(now);
        }
        FileUtils.deleteFileIfExist((String)this.mGetObjectRequest.getDownloadPath());
    }

    @Override
    protected void checking() throws CosXmlClientException {
        super.checking();
    }

    @Override
    protected CosXmlResult execute() throws Exception {
        return this.simpleDownload();
    }

    private GetObjectResult simpleDownload() throws Exception {
        this.simpleDownloadTask = new SimpleDownloadTask(this.cosDirect, this.mGetObjectRequest, this.mTransferTaskCts);
        this.simpleDownloadTask.bucket = this.bucket;
        this.simpleDownloadTask.key = this.key;
        this.simpleDownloadTask.region = this.region;
        this.simpleDownloadTask.setTaskId(this.taskId);
        this.simpleDownloadTask.mTransferMetrics = this.transferTaskMetrics;
        this.mGetObjectRequest.setProgressListener(new CosXmlProgressListener(){

            public void onProgress(long complete, long target) {
                long fileOffset = COSDownloadTask.this.mGetObjectRequest.getFileOffset();
                COSDownloadTask.this.onTransferProgressChange(complete + fileOffset, target + fileOffset);
            }
        });
        this.simpleDownloadTask.run();
        Task<GetObjectResult> task = this.simpleDownloadTask.getTask();
        if (task.isFaulted()) {
            throw task.getError();
        }
        if (task.isCompleted()) {
            return (GetObjectResult)task.getResult();
        }
        COSDownloadTask.loggerInfo(TAG, this.taskId, TASK_UNKNOWN_STATUS, new Object[0]);
        throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), TASK_UNKNOWN_STATUS);
    }

    private static class DownloadRecord {
        String lastModified;
        String eTag;
        @Nullable
        String crc64ecma;
        long remoteStart;
        long remoteEnd;

        public DownloadRecord(String lastModified, String eTag, String crc64ecma, long remoteStart, long remoteEnd) {
            this.lastModified = lastModified;
            this.eTag = eTag;
            this.crc64ecma = crc64ecma;
            this.remoteStart = remoteStart;
            this.remoteEnd = remoteEnd;
        }

        public static String flatJson(DownloadRecord downloadRecord) throws JSONException {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("lastModified", (Object)downloadRecord.lastModified);
            jsonObject.put("eTag", (Object)downloadRecord.eTag);
            jsonObject.put("crc64ecma", (Object)downloadRecord.crc64ecma);
            jsonObject.put("remoteStart", downloadRecord.remoteStart);
            jsonObject.put("remoteEnd", downloadRecord.remoteEnd);
            return jsonObject.toString();
        }

        public static DownloadRecord toJson(String str) throws JSONException {
            JSONObject jsonObject = new JSONObject(str);
            String lastModified = jsonObject.getString("lastModified");
            String eTag = jsonObject.getString("eTag");
            String crc64ecma = jsonObject.optString("crc64ecma");
            String remoteStart = jsonObject.getString("remoteStart");
            String remoteEnd = jsonObject.getString("remoteEnd");
            return new DownloadRecord(lastModified, eTag, crc64ecma, Long.parseLong(remoteStart), Long.parseLong(remoteEnd));
        }
    }

    private class SimpleDownloadTask
    implements Runnable {
        private TaskCompletionSource<GetObjectResult> tcs;
        private COSDirect cosDirect;
        private volatile GetObjectRequest getObjectRequest;
        private volatile HeadObjectRequest headObjectRequest;
        private CancellationTokenSource mTransferTaskCts;
        private String bucket;
        private String region;
        private String key;
        private String taskId;
        private SharedPreferences sharedPreferences;
        private String lastModified;
        private String eTag;
        private String crc64ecma;
        private TransferTaskMetrics mTransferMetrics;

        public SimpleDownloadTask(COSDirect cosDirect, GetObjectRequest getObjectRequest, CancellationTokenSource transferTaskCts) {
            this.cosDirect = cosDirect;
            this.getObjectRequest = getObjectRequest;
            this.tcs = new TaskCompletionSource();
            this.mTransferTaskCts = transferTaskCts;
        }

        @Override
        public void run() {
            try {
                this.checkoutManualCanceled();
                this.checking();
                this.checkoutManualCanceled();
                boolean hasDownloadPart = this.hasDownloadPart();
                this.checkoutManualCanceled();
                this.prepareDownloadContext(hasDownloadPart && !this.cosDirect.isTransferSecurely());
                this.checkoutManualCanceled();
                GetObjectResult getObjectResult = this.download();
                this.checkoutManualCanceled();
                try {
                    this.verifyContent(getObjectResult);
                }
                catch (CosXmlClientException clientException) {
                    FileUtils.deleteFileIfExist((String)this.getObjectRequest.getDownloadPath());
                    throw clientException;
                }
                this.tcs.setResult((Object)getObjectResult);
            }
            catch (Exception e2) {
                this.tcs.setError(e2);
            }
        }

        private void checkoutManualCanceled() throws CosXmlClientException {
            if (this.mTransferTaskCts.isCancellationRequested()) {
                throw CosXmlClientException.manualCancelException();
            }
        }

        public Task<GetObjectResult> getTask() {
            return this.tcs.getTask();
        }

        public void cancel(boolean now) {
            if (this.headObjectRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.headObjectRequest, now);
            }
            if (this.getObjectRequest != null) {
                this.cosDirect.cancel((CosXmlRequest)this.getObjectRequest, now);
            }
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        private void checking() throws CosXmlClientException, CosXmlServiceException {
            Context context = ContextHolder.getAppContext();
            if (context == null) {
                throw CosXmlClientException.internalException((String)"context is null");
            }
            this.sharedPreferences = context.getSharedPreferences(COSDownloadTask.TAG, 0);
            this.headObjectRequest = new HeadObjectRequest(this.bucket, this.key);
            HttpTaskMetrics httpTaskMetrics = new HttpTaskMetrics();
            this.headObjectRequest.attachMetrics(httpTaskMetrics);
            this.headObjectRequest.setRegion(this.region);
            this.headObjectRequest.setRequestHeaders(this.getHeadHeaders(this.getObjectRequest));
            HeadObjectResult headObjectResult = this.cosDirect.headObject(this.headObjectRequest);
            this.mTransferMetrics.connectAddress = httpTaskMetrics.getConnectAddress();
            this.lastModified = headObjectResult.getHeader("Last-Modified");
            this.eTag = headObjectResult.getHeader("ETag");
            this.crc64ecma = headObjectResult.getHeader("x-cos-hash-crc64ecma");
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "start download to %s", this.getObjectRequest.getDownloadPath());
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "checkout remoteStart=%d, remoteEnd=%d, crc64ecma=%s", COSDownloadTask.this.remoteStart, COSDownloadTask.this.remoteEnd, this.crc64ecma);
        }

        private Map<String, List<String>> getHeadHeaders(GetObjectRequest getObjectRequest) {
            Map customHeaders = getObjectRequest.getRequestHeaders();
            if (customHeaders == null) {
                return new HashMap<String, List<String>>();
            }
            return new HashMap<String, List<String>>(customHeaders);
        }

        @Nullable
        private boolean hasDownloadPart() throws CosXmlClientException {
            String downloadRecordStr = this.sharedPreferences.getString(this.key, "");
            if (TextUtils.isEmpty((CharSequence)downloadRecordStr)) {
                COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "not find DownloadRecord", new Object[0]);
                return false;
            }
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "find DownloadRecord: %s", downloadRecordStr);
            try {
                DownloadRecord downloadRecord = DownloadRecord.toJson(downloadRecordStr);
                if (downloadRecord.lastModified == null || !downloadRecord.lastModified.equals(this.lastModified) || downloadRecord.eTag == null || !downloadRecord.eTag.equals(this.eTag) || downloadRecord.crc64ecma != null && this.crc64ecma != null && !downloadRecord.crc64ecma.equals(this.crc64ecma) || downloadRecord.remoteStart != COSDownloadTask.this.remoteStart || downloadRecord.remoteEnd != COSDownloadTask.this.remoteEnd) {
                    COSTransferTask.loggerWarn(COSDownloadTask.TAG, this.taskId, "verify DownloadRecord failed: lastModified:%s, eTag:%s, crc64ecma:%s, remoteStart:%d, remoteEnd:%d", this.lastModified, this.eTag, this.crc64ecma, COSDownloadTask.this.remoteStart, COSDownloadTask.this.remoteEnd);
                    return false;
                }
                return true;
            }
            catch (JSONException e2) {
                COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "parse DownloadRecord failed: %s", e2.getMessage());
                return false;
            }
        }

        private void prepareDownloadContext(boolean hasDownloadPart) {
            File localFile = new File(this.getObjectRequest.getDownloadPath());
            if (hasDownloadPart) {
                long size = localFile.length();
                this.getObjectRequest.setFileOffset(size);
                this.getObjectRequest.setRange(size + COSDownloadTask.this.remoteStart, COSDownloadTask.this.remoteEnd);
                COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "has download part %d", size);
            } else {
                FileUtils.deleteFileIfExist((String)localFile.getAbsolutePath());
            }
        }

        private GetObjectResult download() throws CosXmlClientException, CosXmlServiceException {
            try {
                this.sharedPreferences.edit().putString(this.key, DownloadRecord.flatJson(new DownloadRecord(this.lastModified, this.eTag, this.crc64ecma, COSDownloadTask.this.remoteStart, COSDownloadTask.this.remoteEnd))).apply();
            }
            catch (JSONException e2) {
                COSTransferTask.loggerWarn(COSDownloadTask.TAG, this.taskId, "save DownloadRecord failed: %s", e2.getMessage());
            }
            Range range = this.getObjectRequest.getRange();
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "start download [%d,%d] with fileOffset=%d", range != null ? range.getStart() : 0L, range != null ? range.getEnd() : -1L, this.getObjectRequest.getFileOffset());
            GetObjectResult result = this.cosDirect.getObject(this.getObjectRequest);
            this.sharedPreferences.edit().remove(this.key).apply();
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "download complete", new Object[0]);
            return result;
        }

        private void verifyContent(GetObjectResult getObjectResult) throws CosXmlClientException {
            String remoteCRC64 = getObjectResult.getHeader("x-cos-hash-crc64ecma");
            String unencryptedMd5 = getObjectResult.getHeader("x-cos-meta-client-side-encryption-unencrypted-content-md5");
            File localFile = new File(this.getObjectRequest.getDownloadPath());
            this.mTransferMetrics.size = localFile.length() - this.getObjectRequest.getFileOffset();
            if (this.isRangeDownload()) {
                this.checkCRC64(remoteCRC64, localFile, this.getObjectRequest.getFileOffset(), localFile.length() - this.getObjectRequest.getFileOffset());
            } else if (this.cosDirect.isTransferSecurely()) {
                this.checkMd5(unencryptedMd5, localFile);
            } else {
                this.checkCRC64(remoteCRC64, localFile, 0L, -1L);
            }
        }

        private boolean isRangeDownload() {
            return COSDownloadTask.this.remoteStart != 0L || COSDownloadTask.this.remoteEnd != -1L;
        }

        private void checkMd5(@Nullable String remoteMD5, File localFile) throws CosXmlClientException {
            if (TextUtils.isEmpty((CharSequence)remoteMD5)) {
                return;
            }
            String localMD5 = DigestUtils.getMD5((String)localFile.getAbsolutePath());
            if (!localMD5.equals(remoteMD5 = remoteMD5.replaceAll("\"", ""))) {
                throw CosXmlClientException.internalException((String)("verify MD5 failed, local MD5: " + localMD5 + ", remote MD5: " + remoteMD5));
            }
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "check md5=%s success", remoteMD5);
        }

        private void checkCRC64(@Nullable String remoteCRC, File localFile, long offset, long size) throws CosXmlClientException {
            if (TextUtils.isEmpty((CharSequence)remoteCRC)) {
                return;
            }
            long localCRC64 = 0L;
            try {
                localCRC64 = DigestUtils.getCRC64((InputStream)new FileInputStream(localFile), (long)offset, (long)size);
            }
            catch (FileNotFoundException e2) {
                throw CosXmlClientException.internalException((String)("verify CRC64 failed: " + e2.getMessage()));
            }
            long remoteCRC64 = DigestUtils.getBigIntFromString((String)remoteCRC);
            if (localCRC64 != remoteCRC64) {
                throw CosXmlClientException.internalException((String)("verify CRC64 failed, local crc64: " + localCRC64 + ", remote crc64: " + remoteCRC64));
            }
            COSTransferTask.loggerInfo(COSDownloadTask.TAG, this.taskId, "check offset=%d, size=%d, crc64=%s success", offset, size, remoteCRC);
        }
    }
}

