/*
 * Decompiled with CFR 0.152.
 */
package com.qbw.log;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class XLog {
    private static String sCommonFilterTag = "[xlog]";
    public static final XLog LOGGER = new XLog();
    private boolean mEnabled = false;
    private String mLogDirPath;
    private String mFilterTag = "";
    private final int JSON_INDENT = 4;
    private final String LINE_SEPARATOR = System.getProperty("line.separator");

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled(enabled, "");
    }

    public void setEnabled(boolean enabled, String logDirPath) {
        this.mEnabled = enabled;
        this.mLogDirPath = logDirPath;
    }

    public void setFilterTag(String filterTag) {
        this.mFilterTag = filterTag;
    }

    public void v(String logFormat, Object ... logParam) {
        this.l('v', logFormat, logParam);
    }

    public void d(String logFormat, Object ... logParam) {
        this.l('d', logFormat, logParam);
    }

    public void i(String logFormat, Object ... logParam) {
        this.l('i', logFormat, logParam);
    }

    public void w(String logFormat, Object ... logParam) {
        this.l('w', logFormat, logParam);
    }

    public void w(Throwable e) {
        if (null != e) {
            String message = e.getMessage();
            if (!TextUtils.isEmpty((CharSequence)message)) {
                this.l('w', message, new Object[0]);
            } else {
                this.l('w', "message is empty", new Object[0]);
            }
        }
    }

    public void e(String logFormat, Object ... logParam) {
        this.l('e', logFormat, logParam);
    }

    public void e(Throwable e) {
        if (null != e) {
            String message = e.getMessage();
            if (!TextUtils.isEmpty((CharSequence)message)) {
                this.l('e', message, new Object[0]);
            } else {
                this.l('e', "message is empty", new Object[0]);
            }
        }
    }

    public void jsonV(String message) {
        this.l('v', this.jsonLog(message), new Object[0]);
    }

    public void jsonD(String message) {
        this.l('d', this.jsonLog(message), new Object[0]);
    }

    public void jsonI(String message) {
        this.l('i', this.jsonLog(message), new Object[0]);
    }

    public void jsonW(String message) {
        this.l('w', this.jsonLog(message), new Object[0]);
    }

    public void jsonE(String message) {
        this.l('e', this.jsonLog(message), new Object[0]);
    }

    public void urlV(String url, Map<String, String> mapParam) {
        this.l('v', this.urlLog(url, mapParam), new Object[0]);
    }

    public void urlD(String url, Map<String, String> mapParam) {
        this.l('d', this.urlLog(url, mapParam), new Object[0]);
    }

    public void urlI(String url, Map<String, String> mapParam) {
        this.l('i', this.urlLog(url, mapParam), new Object[0]);
    }

    public void urlW(String url, Map<String, String> mapParam) {
        this.l('w', this.urlLog(url, mapParam), new Object[0]);
    }

    public void urlE(String url, Map<String, String> mapParam) {
        this.l('e', this.urlLog(url, mapParam), new Object[0]);
    }

    private void l(char type, String logFormat, Object ... logParam) {
        block5: {
            try {
                boolean isWriteToFile;
                boolean bl = isWriteToFile = !TextUtils.isEmpty((CharSequence)this.mLogDirPath);
                if (this.mEnabled || isWriteToFile) {
                    String log = String.format(logFormat, logParam);
                    String[] logs = this.createLog(log);
                    if (this.mEnabled) {
                        this.log(type, logs[0], logs[1]);
                    }
                    if (isWriteToFile) {
                        this.writeToFile(logs[0], logs[1]);
                    }
                }
            }
            catch (Exception e) {
                String msg;
                if (e == null || TextUtils.isEmpty((CharSequence)(msg = e.getMessage()))) break block5;
                Log.w((String)"xlog", (String)msg);
            }
        }
    }

    private void log(char level, String tag, String text) {
        int PART_LEN = 3000;
        do {
            int clipLen = text.length() > 3000 ? 3000 : text.length();
            String clipText = text.substring(0, clipLen);
            text = clipText.length() == text.length() ? "" : text.substring(clipLen);
            switch (level) {
                case 'i': {
                    Log.i((String)tag, (String)clipText);
                    break;
                }
                case 'd': {
                    Log.d((String)tag, (String)clipText);
                    break;
                }
                case 'w': {
                    Log.w((String)tag, (String)clipText);
                    break;
                }
                case 'v': {
                    Log.v((String)tag, (String)clipText);
                    break;
                }
                case 'e': {
                    Log.e((String)tag, (String)clipText);
                    break;
                }
            }
        } while (text.length() > 0);
    }

    public String jsonLog(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        try {
            int job = message.indexOf("{");
            int joe = message.lastIndexOf("}");
            int jab = message.indexOf("[");
            int jae = message.lastIndexOf("]");
            int type = job != -1 && (-1 == jab || job < jab) && joe != -1 && joe > job ? 0 : (jab != -1 && (-1 == job || jab < job) && jae != -1 && jae > jab ? 1 : -1);
            if (type == -1) {
                return message;
            }
            StringBuilder jsonLog = new StringBuilder();
            switch (type) {
                case 0: {
                    jsonLog.append(message.substring(0, job)).append(this.LINE_SEPARATOR);
                    jsonLog.append(new JSONObject(message.substring(job, joe + 1)).toString(4)).append(this.LINE_SEPARATOR);
                    jsonLog.append(message.substring(joe + 1, message.length())).append(this.LINE_SEPARATOR);
                    break;
                }
                case 1: {
                    jsonLog.append(message.substring(0, jab)).append(this.LINE_SEPARATOR);
                    jsonLog.append(new JSONArray(message.substring(jab, jae + 1)).toString(4)).append(this.LINE_SEPARATOR);
                    jsonLog.append(message.substring(jae + 1, message.length())).append(this.LINE_SEPARATOR);
                    break;
                }
            }
            return jsonLog.toString();
        }
        catch (Exception e) {
            String msg;
            if (e != null && !TextUtils.isEmpty((CharSequence)(msg = e.getMessage()))) {
                Log.w((String)"xlog", (String)msg);
            }
            return "";
        }
    }

    public String urlLog(String url, Map<String, String> mapParam) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url + "?");
        if (null != mapParam && !mapParam.isEmpty()) {
            Set<Map.Entry<String, String>> entrySet = mapParam.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "&");
            }
        }
        url = stringBuilder.toString();
        return url.substring(0, url.length() - 1);
    }

    public void line(boolean top) {
        if (top) {
            this.l('v', "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        } else {
            this.l('v', "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        }
    }

    private String[] createLog(String log) {
        String tag;
        if (null == log) {
            log = "";
        }
        String string = tag = this.mEnabled ? this.getFileNameMethodLineNumber(6) : "";
        if (null == tag) {
            tag = "";
        }
        tag = sCommonFilterTag + this.mFilterTag + tag;
        return new String[]{tag, log};
    }

    private void writeToFile(String tag, String msg) {
        if (!"mounted".equals(Environment.getExternalStorageState())) {
            Log.e((String)"", (String)"no external storage!!!");
            return;
        }
        Date date = Calendar.getInstance().getTime();
        String logName = String.format("%1$04d%2$02d%3$02d.txt", date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        File fLogDir = new File(this.mLogDirPath);
        if (!fLogDir.exists() && !fLogDir.mkdirs()) {
            Log.e((String)"", (String)("create dir[" + this.mLogDirPath + "]failed!!!"));
            return;
        }
        try {
            File f = new File(this.mLogDirPath + File.separator + logName);
            if (!f.exists() && !f.createNewFile()) {
                Log.e((String)"", (String)"create file failed");
                return;
            }
            FileOutputStream fout = new FileOutputStream(f, true);
            OutputStreamWriter swriter = new OutputStreamWriter(fout);
            BufferedWriter bwriter = new BufferedWriter(swriter);
            bwriter.write(String.format("[%1$02d:%2$02d:%3$02d]%4$50s:%5$s\n", date.getHours(), date.getMinutes(), date.getSeconds(), tag, msg));
            bwriter.flush();
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.d((String)"exception", (String)e.getMessage());
        }
    }

    private String getFileNameMethodLineNumber(int depth) {
        String info = "";
        try {
            StackTraceElement e = Thread.currentThread().getStackTrace()[depth];
            if (!TextUtils.isEmpty((CharSequence)e.getFileName()) && !TextUtils.isEmpty((CharSequence)e.getMethodName())) {
                info = String.format("[%1$s,%2$s,%3$s]", e.getFileName(), e.getMethodName(), e.getLineNumber());
            }
        }
        catch (Exception e) {
            Log.e((String)"log", (String)"get stack trace element failed!!!");
        }
        return info;
    }
}

