/*
 * Decompiled with CFR 0.152.
 */
package com.qbw.log;

import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class XLog {
    private static boolean sEnabled = false;
    private static String sLogDirPath;
    private static String sFilterTag;
    private static final int JSON_INDENT = 4;
    private static final String LINE_SEPARATOR;

    public static boolean isEnabled() {
        return sEnabled;
    }

    public static void setEnabled(boolean enabled) {
        XLog.setEnabled(enabled, "");
    }

    public static void setEnabled(boolean enabled, String logDirPath) {
        sEnabled = enabled;
        sLogDirPath = logDirPath;
    }

    public static void setFilterTag(String filterTag) {
        sFilterTag = filterTag;
    }

    public static void v(String logFormat, Object ... logParam) {
        XLog.l('v', logFormat, logParam);
    }

    public static void d(String logFormat, Object ... logParam) {
        XLog.l('d', logFormat, logParam);
    }

    public static void i(String logFormat, Object ... logParam) {
        XLog.l('i', logFormat, logParam);
    }

    public static void w(String logFormat, Object ... logParam) {
        XLog.l('w', logFormat, logParam);
    }

    public static void w(Throwable e) {
        String message;
        if (null != e && !TextUtils.isEmpty((CharSequence)(message = e.getMessage()))) {
            XLog.l('w', message, new Object[0]);
        }
    }

    public static void e(String logFormat, Object ... logParam) {
        XLog.l('e', logFormat, logParam);
    }

    public static void e(Throwable e) {
        String message;
        if (null != e && !TextUtils.isEmpty((CharSequence)(message = e.getMessage()))) {
            XLog.l('e', message, new Object[0]);
        }
    }

    private static void l(char type, String logFormat, Object ... logParam) {
        try {
            boolean isWriteToFile;
            boolean bl = isWriteToFile = !TextUtils.isEmpty((CharSequence)sLogDirPath);
            if (sEnabled || isWriteToFile) {
                String log = String.format(logFormat, logParam);
                String[] logs = XLog.createLog(log);
                if (sEnabled) {
                    XLog.log(type, logs[0], logs[1]);
                }
                if (isWriteToFile) {
                    XLog.writeToFile(logs[0], logs[1]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void log(char level, String tag, String text) {
        int PART_LEN = 3000;
        do {
            int clipLen = text.length() > 3000 ? 3000 : text.length();
            String clipText = text.substring(0, clipLen);
            text = clipText.length() == text.length() ? "" : text.substring(clipLen);
            switch (level) {
                case 'i': {
                    Log.i((String)tag, (String)clipText);
                    break;
                }
                case 'd': {
                    Log.d((String)tag, (String)clipText);
                    break;
                }
                case 'w': {
                    Log.w((String)tag, (String)clipText);
                    break;
                }
                case 'v': {
                    Log.v((String)tag, (String)clipText);
                    break;
                }
                case 'e': {
                    Log.e((String)tag, (String)clipText);
                    break;
                }
            }
        } while (text.length() > 0);
    }

    public static synchronized void json(String header, String msg) {
        String message;
        if (!sEnabled) {
            return;
        }
        try {
            if (msg.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(msg);
                message = jsonObject.toString(4);
            } else if (msg.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(msg);
                message = jsonArray.toString(4);
            } else {
                message = msg;
            }
        }
        catch (JSONException e) {
            message = msg;
        }
        XLog.l('d', "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        message = header + LINE_SEPARATOR + message;
        String[] lines = message.split(LINE_SEPARATOR);
        StringBuffer linesBuffer = new StringBuffer();
        linesBuffer.append(LINE_SEPARATOR);
        for (String line : lines) {
            XLog.l('d', "\u2551 " + line, new Object[0]);
        }
        XLog.l('d', "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
    }

    public static void url(String url, Map<String, String> mapParam) {
        if (!sEnabled) {
            return;
        }
        XLog.l('d', XLog.urlLog(url, mapParam), new Object[0]);
    }

    public static void urlE(String url, Map<String, String> mapParam) {
        if (!sEnabled) {
            return;
        }
        XLog.l('e', XLog.urlLog(url, mapParam), new Object[0]);
    }

    public static String urlLog(String url, Map<String, String> mapParam) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url + "?");
        if (null != mapParam && !mapParam.isEmpty()) {
            Set<Map.Entry<String, String>> entrySet = mapParam.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                stringBuilder.append(entry.getKey() + "=" + entry.getValue() + "&");
            }
        }
        url = stringBuilder.toString();
        return url.substring(0, url.length() - 1);
    }

    public static void line(boolean top) {
        if (top) {
            XLog.l('v', "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        } else {
            XLog.l('v', "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550", new Object[0]);
        }
    }

    private static String[] createLog(String log) {
        String tag;
        if (null == log) {
            log = "";
        }
        String string = tag = sEnabled ? XLog.getFileNameMethodLineNumber(6) : "";
        if (null == tag) {
            tag = "";
        }
        tag = "[" + sFilterTag + "]" + tag;
        return new String[]{tag, log};
    }

    private static void writeToFile(String tag, String msg) {
        if (!"mounted".equals(Environment.getExternalStorageState())) {
            Log.e((String)"", (String)"no external storage!!!");
            return;
        }
        Date date = Calendar.getInstance().getTime();
        String logName = String.format("%1$04d%2$02d%3$02d.txt", date.getYear() + 1900, date.getMonth() + 1, date.getDate());
        File fLogDir = new File(sLogDirPath);
        if (!fLogDir.exists() && !fLogDir.mkdirs()) {
            Log.e((String)"", (String)("create dir[" + sLogDirPath + "]failed!!!"));
            return;
        }
        try {
            File f = new File(sLogDirPath + File.separator + logName);
            if (!f.exists() && !f.createNewFile()) {
                Log.e((String)"", (String)"create file failed");
                return;
            }
            FileOutputStream fout = new FileOutputStream(f, true);
            OutputStreamWriter swriter = new OutputStreamWriter(fout);
            BufferedWriter bwriter = new BufferedWriter(swriter);
            bwriter.write(String.format("[%1$02d:%2$02d:%3$02d]%4$50s:%5$s\n", date.getHours(), date.getMinutes(), date.getSeconds(), tag, msg));
            bwriter.flush();
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.d((String)"exception", (String)e.getMessage());
        }
    }

    private static String getFileNameMethodLineNumber(int depth) {
        String info = new String("");
        try {
            StackTraceElement e = Thread.currentThread().getStackTrace()[depth];
            info = String.format("[%1$s,%2$s,%3$s]", e.getFileName(), e.getMethodName(), e.getLineNumber());
        }
        catch (Exception e) {
            Log.e((String)"log", (String)"get stack trace element failed!!!");
        }
        return info;
    }

    static {
        sFilterTag = "xlog";
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

