/*
 * Decompiled with CFR 0.152.
 */
package com.qbw.customview.titlebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.qbw.customview.titlebar.R;
import java.util.HashMap;
import java.util.Map;

public class TitleBar
extends FrameLayout
implements View.OnClickListener {
    private final String TAG = ((Object)((Object)this)).getClass().getName();
    private Map<Integer, Long> mViewClicked = new HashMap<Integer, Long>();
    private Listener mListener;
    private View mViewStatus;
    private ViewGroup mVgTitle;
    private TextView mTxtTitle;
    private TextView mTvSubTitle;
    private ViewGroup mVgTitleLayout;
    private ViewGroup mVgSubTitleLayout;
    private ViewGroup mVgLeft;
    private TextView mTxtLeft;
    private ImageView mImgLeft;
    private ViewGroup mVgRight;
    private TextView mTxtRight;
    private ImageView mImgRight;
    private View mVBottomLine;
    private int mFastClickDuration = 500;

    public TitleBar(Context context) {
        super(context);
        this.init(null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        int theight;
        int leftMargin;
        Drawable bg;
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tb_view_titlebar, (ViewGroup)this, true);
        this.mViewStatus = view.findViewById(R.id.view_status);
        this.mVgTitle = (ViewGroup)view.findViewById(R.id.layout_title);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txt_title);
        this.mVgLeft = (ViewGroup)view.findViewById(R.id.layout_left);
        this.mTxtLeft = (TextView)view.findViewById(R.id.txt_left);
        this.mImgLeft = (ImageView)view.findViewById(R.id.img_left);
        this.mVgRight = (ViewGroup)view.findViewById(R.id.layout_right);
        this.mTxtRight = (TextView)view.findViewById(R.id.txt_right);
        this.mImgRight = (ImageView)view.findViewById(R.id.img_right);
        this.mTvSubTitle = (TextView)view.findViewById(R.id.tv_sub_title);
        this.mVgTitleLayout = (ViewGroup)view.findViewById(R.id.layout_main_title);
        this.mVgSubTitleLayout = (ViewGroup)view.findViewById(R.id.layout_sub_title);
        this.mVBottomLine = view.findViewById(R.id.v_bottom_line);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        Drawable sbg = typedArray.getDrawable(R.styleable.TitleBar_tb_status_background);
        if (sbg != null) {
            this.mViewStatus.setBackgroundDrawable(sbg);
        }
        this.mViewStatus.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_status_visible, false) ? 0 : 8);
        if (!this.adjustStatusHeight()) {
            int sheight = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_status_height, -1);
            if (sheight == -1) {
                sheight = (int)this.getContext().getResources().getDimension(R.dimen.tb_status_height);
            }
            ViewGroup.LayoutParams paramsSh = this.mViewStatus.getLayoutParams();
            paramsSh.height = sheight;
            this.mViewStatus.setLayoutParams(paramsSh);
        }
        if ((bg = typedArray.getDrawable(R.styleable.TitleBar_tb_backgroupd)) != null) {
            view.setBackgroundDrawable(bg);
        }
        int defaultColor = this.getResources().getColor(17170443);
        this.mTxtTitle.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_title));
        this.mTxtTitle.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_title_color, defaultColor));
        this.mTxtTitle.setTextSize(0, typedArray.getDimension(R.styleable.TitleBar_tb_title_textsize, 55.0f));
        this.mTxtTitle.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_title_visible, true) ? 0 : 4);
        boolean isBold = typedArray.getBoolean(R.styleable.TitleBar_tb_title_bold, true);
        if (isBold) {
            this.mTxtTitle.setTypeface(null, 1);
        }
        this.mVgSubTitleLayout.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_sub_title_visible, false) ? 0 : 8);
        this.mTvSubTitle.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_sub_title));
        int defaultSubTitleColor = Color.parseColor((String)"#999999");
        this.mTvSubTitle.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_sub_title_color, defaultSubTitleColor));
        this.mTvSubTitle.setTextSize(0, typedArray.getDimension(R.styleable.TitleBar_tb_sub_title_size, 22.0f));
        this.mVgLeft.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_left_visible, false) ? 0 : 8);
        this.mTxtLeft.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_left_text));
        this.mTxtLeft.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_left_text_color, defaultColor));
        this.mTxtLeft.setTextSize(0, typedArray.getDimension(R.styleable.TitleBar_tb_left_text_size, 22.0f));
        if (typedArray.getBoolean(R.styleable.TitleBar_tb_left_text_bold, false)) {
            this.mTxtLeft.setTypeface(null, 1);
        }
        LinearLayout.LayoutParams tvLeftParams = (LinearLayout.LayoutParams)this.mTxtLeft.getLayoutParams();
        tvLeftParams.leftMargin = (int)typedArray.getDimension(R.styleable.TitleBar_tb_left_text_margin_left, 0.0f);
        this.mTxtLeft.setLayoutParams((ViewGroup.LayoutParams)tvLeftParams);
        Drawable drawableLeft = typedArray.getDrawable(R.styleable.TitleBar_tb_left_image);
        this.mImgLeft.setImageDrawable(drawableLeft);
        this.mImgLeft.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_left_image_visible, false) ? 0 : 8);
        int leftImageMarginLeft = (int)typedArray.getDimension(R.styleable.TitleBar_tb_left_image_margin_left, 0.0f);
        if (leftImageMarginLeft != 0) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mImgLeft.getLayoutParams();
            params.leftMargin = leftImageMarginLeft;
            this.mImgLeft.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if ((leftMargin = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_left_margin, 0)) != 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mVgLeft.getLayoutParams();
            params.leftMargin = leftMargin;
            this.mVgLeft.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mVgRight.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_right_visible, false) ? 0 : 8);
        this.mTxtRight.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_right_text));
        this.mTxtRight.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_right_text_color, defaultColor));
        this.mTxtRight.setTextSize(0, typedArray.getDimension(R.styleable.TitleBar_tb_right_text_size, 22.0f));
        this.mImgRight.setImageDrawable(typedArray.getDrawable(R.styleable.TitleBar_tb_right_image));
        int rightMargin = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_right_margin, 0);
        if (rightMargin != 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mVgRight.getLayoutParams();
            params.rightMargin = rightMargin;
            this.mVgRight.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if ((theight = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_title_height, -1)) == -1) {
            theight = (int)this.getContext().getResources().getDimension(R.dimen.tb_title_height);
        }
        ViewGroup.LayoutParams paramsTh = this.mVgTitle.getLayoutParams();
        paramsTh.height = theight;
        this.mVgTitle.setLayoutParams(paramsTh);
        this.mVgLeft.setMinimumWidth(theight);
        this.mVgRight.setMinimumWidth(theight);
        int titleMarginTop = (int)typedArray.getDimension(R.styleable.TitleBar_tb_title_margin_top, 1.0f);
        int subTitleMarginTop = (int)typedArray.getDimension(R.styleable.TitleBar_tb_sub_title_margin_top, 1.0f);
        LinearLayout.LayoutParams titleParams = (LinearLayout.LayoutParams)this.mVgTitleLayout.getLayoutParams();
        titleParams.topMargin = titleMarginTop;
        titleParams = (LinearLayout.LayoutParams)this.mVgSubTitleLayout.getLayoutParams();
        titleParams.topMargin = subTitleMarginTop;
        boolean showBottomLine = typedArray.getBoolean(R.styleable.TitleBar_tb_bottom_line_visible, false);
        this.mVBottomLine.setVisibility(showBottomLine ? 0 : 8);
        int bottomLineColor = typedArray.getColor(R.styleable.TitleBar_tb_bottom_line_color, 0);
        this.mVBottomLine.setBackgroundColor(bottomLineColor);
        Drawable rightTextBg = typedArray.getDrawable(R.styleable.TitleBar_tb_right_text_background);
        if (rightTextBg != null) {
            this.mTxtRight.setBackgroundDrawable(rightTextBg);
        }
        int rightTextWidth = (int)typedArray.getDimension(R.styleable.TitleBar_tb_right_text_width, -1.0f);
        int rightTextHeight = (int)typedArray.getDimension(R.styleable.TitleBar_tb_right_text_height, -1.0f);
        if (rightTextWidth >= 0 && rightTextHeight >= 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mTxtRight.getLayoutParams();
            params.width = rightTextWidth;
            params.height = rightTextHeight;
            this.mTxtRight.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mVgLeft.setOnClickListener((View.OnClickListener)this);
        this.mTxtLeft.setOnClickListener((View.OnClickListener)this);
        this.mImgLeft.setOnClickListener((View.OnClickListener)this);
        this.mVgRight.setOnClickListener((View.OnClickListener)this);
        this.mTxtRight.setOnClickListener((View.OnClickListener)this);
        this.mImgRight.setOnClickListener((View.OnClickListener)this);
        this.mTxtTitle.setOnClickListener((View.OnClickListener)this);
        typedArray.recycle();
    }

    public void onClick(View v) {
        if (this.mListener == null) {
            return;
        }
        int vid = v.getId();
        if (this.mViewClicked.containsKey(vid)) {
            long lastClickTime = this.mViewClicked.get(vid);
            if (System.currentTimeMillis() - lastClickTime <= (long)this.mFastClickDuration) {
                Log.w((String)this.TAG, (String)"you click so fast!");
                return;
            }
        }
        this.mViewClicked.put(vid, System.currentTimeMillis());
        if (vid == R.id.layout_left || vid == R.id.txt_left || vid == R.id.img_left) {
            this.mListener.onLeftAreaClick();
        } else if (vid == R.id.layout_right || vid == R.id.txt_right || vid == R.id.img_right) {
            this.mListener.onRightAreaClick();
        } else if (vid == R.id.txt_title) {
            this.mListener.onCenterAreaClick();
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setRightVisible(boolean b) {
        this.mVgRight.setVisibility(b ? 0 : 8);
    }

    public void setLeftVisible(boolean b) {
        this.mVgLeft.setVisibility(b ? 0 : 8);
    }

    public void setLeftImageVisible(boolean show) {
        this.mImgLeft.setVisibility(show ? 0 : 8);
    }

    public void setLeftImage(int drawable) {
        this.mImgLeft.setImageResource(drawable);
    }

    public void setLeftImage(Drawable drawable) {
        this.mImgLeft.setImageDrawable(drawable);
    }

    public void setRightText(int resText) {
        this.mTxtRight.setText(resText);
    }

    public void setRightText(String text) {
        this.mTxtRight.setText((CharSequence)text);
    }

    public void setRightTextColor(int color2) {
        this.mTxtRight.setTextColor(color2);
    }

    public String getRightText() {
        return this.mTxtRight.getText().toString();
    }

    public void setTitle(String title) {
        this.mTxtTitle.setText((CharSequence)title);
    }

    public void setTitle(int resTitle) {
        this.mTxtTitle.setText(resTitle);
    }

    public String getTitle() {
        return this.mTxtTitle.getText().toString();
    }

    public void setTitleBackground(Drawable drawable) {
        this.mTxtTitle.setBackgroundDrawable(drawable);
    }

    public void setTitleVisible(boolean b) {
        this.mVgTitle.setVisibility(b ? 0 : 8);
    }

    public void setSubTitle(String subTitle) {
        this.mTvSubTitle.setText((CharSequence)subTitle);
    }

    public void setSubTitle(int subTitle) {
        this.mTvSubTitle.setText(subTitle);
    }

    public void setSubTitleVisible(boolean b) {
        this.mVgSubTitleLayout.setVisibility(b ? 0 : 8);
    }

    public String getSubTitle() {
        return this.mTvSubTitle.getText().toString();
    }

    public void setLeftText(int resText) {
        this.mTxtLeft.setText(resText);
    }

    public void setLeftText(String text) {
        this.mTxtLeft.setText((CharSequence)text);
    }

    public String getLeftText() {
        return this.mTxtLeft.getText().toString();
    }

    public void setLeftTextColor(int color2) {
        this.mTxtLeft.setTextColor(color2);
    }

    public void setStatusVisible(boolean show) {
        this.mViewStatus.setVisibility(show ? 0 : 8);
    }

    public void setStatusBackground(Drawable drawable) {
        this.mViewStatus.setBackgroundDrawable(drawable);
    }

    public void setTitleSize(float textSize) {
        this.mTxtTitle.setTextSize(0, textSize);
    }

    public void setTitleColor(int color2) {
        this.mTxtTitle.setTextColor(color2);
    }

    public boolean adjustStatusHeight() {
        int height = TitleBar.getStatusHeight(this.getContext());
        if (height != -1) {
            ViewGroup.LayoutParams paramsSh = this.mViewStatus.getLayoutParams();
            paramsSh.height = height;
            this.mViewStatus.setLayoutParams(paramsSh);
            return true;
        }
        return false;
    }

    public static int getStatusHeight(Context context) {
        int statusHeight = -1;
        try {
            Class<?> clazz = Class.forName("com.android.internal.R$dimen");
            Object object = clazz.newInstance();
            int height = Integer.parseInt(clazz.getField("status_bar_height").get(object).toString());
            statusHeight = context.getResources().getDimensionPixelSize(height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusHeight;
    }

    public void setFastClickDuration(int fastClickDuration) {
        this.mFastClickDuration = fastClickDuration;
    }

    public static interface Listener {
        public void onLeftAreaClick();

        public void onRightAreaClick();

        public void onCenterAreaClick();
    }
}

