/*
 * Decompiled with CFR 0.152.
 */
package com.qbw.customview.titlebar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.qbw.customview.titlebar.R;

public class TitleBar
extends FrameLayout
implements View.OnClickListener {
    private Listener mListener;
    private View mViewStatus;
    private ViewGroup mVgTitle;
    private TextView mTxtTitle;
    private ViewGroup mVgLeft;
    private TextView mTxtLeft;
    private ImageView mImgLeft;
    private ViewGroup mVgRight;
    private TextView mTxtRight;
    private ImageView mImgRight;

    public TitleBar(Context context) {
        super(context);
        this.init(null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        int theight;
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tb_view_titlebar, (ViewGroup)this, true);
        this.mViewStatus = view.findViewById(R.id.view_status);
        this.mVgTitle = (ViewGroup)view.findViewById(R.id.layout_title);
        this.mTxtTitle = (TextView)view.findViewById(R.id.txt_title);
        this.mVgLeft = (ViewGroup)view.findViewById(R.id.layout_left);
        this.mTxtLeft = (TextView)view.findViewById(R.id.txt_left);
        this.mImgLeft = (ImageView)view.findViewById(R.id.img_left);
        this.mVgRight = (ViewGroup)view.findViewById(R.id.layout_right);
        this.mTxtRight = (TextView)view.findViewById(R.id.txt_right);
        this.mImgRight = (ImageView)view.findViewById(R.id.img_right);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        Drawable sbg = typedArray.getDrawable(R.styleable.TitleBar_tb_status_background);
        if (sbg != null) {
            this.mViewStatus.setBackgroundDrawable(sbg);
        }
        this.mViewStatus.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_status_visible, false) ? 0 : 8);
        int sheight = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_status_height, -1);
        if (sheight == -1) {
            sheight = (int)this.getContext().getResources().getDimension(R.dimen.tb_status_height);
        }
        ViewGroup.LayoutParams paramsSh = this.mViewStatus.getLayoutParams();
        paramsSh.height = sheight;
        this.mViewStatus.setLayoutParams(paramsSh);
        Drawable bg = typedArray.getDrawable(R.styleable.TitleBar_tb_backgroupd);
        if (bg != null) {
            view.setBackgroundDrawable(bg);
        }
        int defaultColor = this.getResources().getColor(17170443);
        this.mTxtTitle.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_title));
        this.mTxtTitle.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_title_color, defaultColor));
        this.mTxtTitle.setTextSize(0, typedArray.getDimension(R.styleable.TitleBar_tb_title_textsize, 55.0f));
        this.mTxtTitle.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_title_visible, true) ? 0 : 4);
        boolean isBold = typedArray.getBoolean(R.styleable.TitleBar_tb_title_bold, true);
        if (isBold) {
            this.mTxtTitle.setTypeface(null, 1);
        }
        this.mVgLeft.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_left_visible, false) ? 0 : 8);
        this.mTxtLeft.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_left_text));
        this.mTxtLeft.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_left_text_color, defaultColor));
        Drawable drawableLeft = typedArray.getDrawable(R.styleable.TitleBar_tb_left_image);
        this.mImgLeft.setImageDrawable(drawableLeft);
        this.mImgLeft.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_left_image_visible, false) ? 0 : 8);
        int leftMargin = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_left_margin, 0);
        if (leftMargin != 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mVgLeft.getLayoutParams();
            params.leftMargin = leftMargin;
            this.mVgLeft.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.mVgRight.setVisibility(typedArray.getBoolean(R.styleable.TitleBar_tb_right_visible, false) ? 0 : 8);
        this.mTxtRight.setText((CharSequence)typedArray.getString(R.styleable.TitleBar_tb_right_text));
        this.mTxtRight.setTextColor(typedArray.getColor(R.styleable.TitleBar_tb_right_text_color, defaultColor));
        this.mImgRight.setImageDrawable(typedArray.getDrawable(R.styleable.TitleBar_tb_right_image));
        int rightMargin = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_right_margin, 0);
        if (rightMargin != 0) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mVgRight.getLayoutParams();
            params.rightMargin = rightMargin;
            this.mVgRight.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if ((theight = typedArray.getDimensionPixelSize(R.styleable.TitleBar_tb_title_height, -1)) == -1) {
            theight = (int)this.getContext().getResources().getDimension(R.dimen.tb_title_height);
        }
        ViewGroup.LayoutParams paramsTh = this.mVgTitle.getLayoutParams();
        paramsTh.height = theight;
        this.mVgTitle.setLayoutParams(paramsTh);
        this.mVgLeft.setMinimumWidth(theight);
        this.mVgRight.setMinimumWidth(theight);
        this.mVgLeft.setOnClickListener((View.OnClickListener)this);
        this.mTxtLeft.setOnClickListener((View.OnClickListener)this);
        this.mImgLeft.setOnClickListener((View.OnClickListener)this);
        this.mVgRight.setOnClickListener((View.OnClickListener)this);
        this.mTxtRight.setOnClickListener((View.OnClickListener)this);
        this.mImgRight.setOnClickListener((View.OnClickListener)this);
        this.mTxtTitle.setOnClickListener((View.OnClickListener)this);
        typedArray.recycle();
    }

    public void onClick(View v) {
        if (this.mListener == null) {
            return;
        }
        long vid = v.getId();
        if (vid == (long)R.id.layout_left || vid == (long)R.id.txt_left || vid == (long)R.id.img_left) {
            this.mListener.onLeftAreaClick();
        } else if (vid == (long)R.id.layout_right || vid == (long)R.id.txt_right || vid == (long)R.id.img_right) {
            this.mListener.onRightAreaClick();
        } else if (vid == (long)R.id.txt_title) {
            this.mListener.onCenterAreaClick();
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setRightVisible(boolean b) {
        this.mVgRight.setVisibility(b ? 0 : 8);
    }

    public void setLeftVisible(boolean b) {
        this.mVgLeft.setVisibility(b ? 0 : 8);
    }

    public void setTitle(String title) {
        this.mTxtTitle.setText((CharSequence)title);
    }

    public void setTitle(int resTitle) {
        this.mTxtTitle.setText(resTitle);
    }

    public static interface Listener {
        public void onLeftAreaClick();

        public void onRightAreaClick();

        public void onCenterAreaClick();
    }
}

