package org.qas.qtest.api.services.user.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.user.model.UserProfile;

/**
 * ProfileJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ProfileJsonUnmarshaller 2014-07-10 21:25:30z dungvnguyen $
 * @since 1.0
 */
public class UserProfileJsonUnmarshaller extends AbstractUnmarshaller<UserProfile, JsonUnmarshallerContext> {
  private static UserProfileJsonUnmarshaller instance;

  public static UserProfileJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new UserProfileJsonUnmarshaller();
    }
    return instance;
  }

  @Override
  public UserProfile parse(String data) throws Exception {
    return JsonMapper.parseJson(data, UserProfile.class);
  }
}
