package org.qas.qtest.api.services.user;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.user.model.*;

import java.util.List;

/**
 * UserProfileService
 *
 * @author trongle
 * @since 1.4.2
 */
public interface UserProfileService extends QTestService {
  /**
   * Creates user from the given {@link CreateUserRequest create user request} instance.
   *
   * @param getUserProfileRequest
   * @return the user information.
   * @throws AuthServiceException if an error occurs during creating user.
   */
  UserProfile get(GetUserProfileRequest getUserProfileRequest) throws AuthServiceException;

  /**
   * Assign user to project from the request.
   *
   * @param assignToProjectRequest the given assign to project request.
   * @return the assign to project result.
   * @throws AuthServiceException if an error occurs during assigning user to project.
   */
  List<User> batchAssignUsers(AssignToProjectRequest assignToProjectRequest) throws AuthServiceException;
}
