package org.qas.qtest.api.services.search.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.internal.model.ObjectType;
import org.qas.qtest.api.services.search.model.ArtifactSearchType;
import org.qas.qtest.api.services.search.model.SearchHistoryRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * @author trongle
 * @since 1.4.9
 */
public class SearchHistoryMarshaller extends AbstractMarshaller<Request, SearchHistoryRequest> {
  
  @Override
  protected void validateRequest(SearchHistoryRequest in) throws Exception {
    if (in == null) {
      throw new IllegalArgumentException("Invalid request");
    }
    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new IllegalArgumentException("Invalid project id");
    }
    if (in.getPage() <= 0) {
      throw new IllegalArgumentException("Invalid page number");
    }
    if (in.getPageSize() < 0) {
      throw new IllegalArgumentException("Invalid page size");
    }
  }
  
  
  @Override
  protected String getServiceName() {
    return "SearchService";
  }
  
  @Override
  protected String getActionName() {
    return "searchHistory";
  }
  
  @Override
  protected void build(Request request, SearchHistoryRequest in) {
    super.build(request, in);
    request.setHttpMethod(HttpMethod.POST);
  }
  
  @Override
  protected String getContent(SearchHistoryRequest in) {
    Map<String, Object> map = new HashMap<>();
    map.put("object_type", in.getObjectType().getPath());
    map.put("fields", in.getFields());
    map.put("query", in.getQuery());
    map.put("object_query", in.getObjectQuery());
    return JsonMapper.toJson(map);
  }
  
  @Override
  protected StringBuilder getResourcePath(SearchHistoryRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId().longValue()).append("/")
      .append("histories");
    return buildPaging(rpBuilder, in);
  }
}
