package org.qas.qtest.api.services.search.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.Dates;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.search.model.SearchCommentRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * @author trongle
 * @since 1.4.9
 */
public class SearchCommentMarshaller extends AbstractMarshaller<Request, SearchCommentRequest> {
  
  @Override
  protected void validateRequest(SearchCommentRequest in) throws Exception {
    if (in == null) {
      throw new IllegalArgumentException("Invalid request");
    }
    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new IllegalArgumentException("Invalid project id");
    }
    if (in.getPage() <= 0) {
      throw new IllegalArgumentException("Invalid page number");
    }
    if (in.getPageSize() < 0) {
      throw new IllegalArgumentException("Invalid page size");
    }
  }
  
  
  @Override
  protected String getServiceName() {
    return "SearchService";
  }
  
  @Override
  protected String getActionName() {
    return "searchComment";
  }
  
  @Override
  protected void build(Request request, SearchCommentRequest in) {
    super.build(request, in);
    request.setHttpMethod(HttpMethod.POST);
  }
  
  @Override
  protected String getContent(SearchCommentRequest in) {
    Map<String, Object> map = new HashMap<>();
    
    map.put("object_type", in.getObjectType().getPath());
    map.put("fields", in.getFields());
    
    if (null != in.getStart()) {
      map.put("start", Dates.getInstance().formatIso8601Date(in.getStart()));
    }
    if (null != in.getEnd()) {
      map.put("end", Dates.getInstance().formatIso8601Date(in.getEnd()));
    }
    if (in.getObjectId() > 0) {
      map.put("object", in.getObjectId());
    }
    if (in.getAuthorId() > 0) {
      map.put("author", in.getAuthorId());
    }
    return JsonMapper.toJson(map);
  }
  
  @Override
  protected StringBuilder getResourcePath(SearchCommentRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId().longValue()).append("/")
      .append("comments");
    return buildPaging(rpBuilder, in);
  }
}
