package org.qas.qtest.api.services.search.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.qas.api.DateTimeDeserializer;
import org.qas.api.DateTimeSerializer;
import org.qas.api.JsonModel;
import org.qas.qtest.api.internal.model.Link;

import java.util.Date;
import java.util.List;

@JsonModel
public class History {
  @JsonProperty("links")
  private List<Link> links;
  
  @JsonProperty("created")
  private Date created;
  
  @JsonProperty("description")
  private String description;
  
  @JsonProperty("id")
  private int id;
  
  @JsonProperty("author_id")
  private int authorId;
  
  @JsonProperty("linked_object")
  LinkedObject linkedObject;
  
  @JsonProperty("changes")
  List<HistoryChange> changes;
  
  public List<Link> getLinks() {
    return links;
  }
  
  public History setLinks(List<Link> links) {
    this.links = links;
    return this;
  }
  
  @JsonSerialize(using = DateTimeSerializer.class, typing = JsonSerialize.Typing.STATIC, include = JsonSerialize.Inclusion.NON_NULL)
  public Date getCreated() {
    return created;
  }
  
  @JsonDeserialize(using = DateTimeDeserializer.class)
  public History setCreated(Date created) {
    this.created = created;
    return this;
  }
  
  public String getDescription() {
    return description;
  }
  
  public History setDescription(String description) {
    this.description = description;
    return this;
  }
  
  public int getId() {
    return id;
  }
  
  public History setId(int id) {
    this.id = id;
    return this;
  }
  
  public int getAuthorId() {
    return authorId;
  }
  
  public History setAuthorId(int authorId) {
    this.authorId = authorId;
    return this;
  }
  
  public LinkedObject getLinkedObject() {
    return linkedObject;
  }
  
  public History setLinkedObject(LinkedObject linkedObject) {
    this.linkedObject = linkedObject;
    return this;
  }
  
  public List<HistoryChange> getChanges() {
    return changes;
  }
  
  public History setChanges(List<HistoryChange> changes) {
    this.changes = changes;
    return this;
  }
}
