package org.qas.qtest.api.services.search.model;

import org.qas.qtest.api.internal.model.ObjectType;

/**
 * @author trongle
 * @since 1.4.9
 */
public enum ArtifactSearchType {
  Release(ObjectType.Release),
  Build(ObjectType.Build),
  Requirement(ObjectType.Requirement),
  TestCase(ObjectType.TestCase),
  TestCycle(ObjectType.TestCycle),
  TestSuite(ObjectType.TestSuite),
  TestRun(ObjectType.TestRun),
  Defect(ObjectType.Defect),;
  private final ObjectType objectType;
  
  ArtifactSearchType(ObjectType objectType) {
    this.objectType = objectType;
  }
  
  public ObjectType getObjectType() {
    return objectType;
  }
}
