package org.qas.qtest.api.services.search;

import org.qas.api.AuthClientException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.defect.model.Defect;
import org.qas.qtest.api.services.design.model.TestCase;
import org.qas.qtest.api.services.execution.model.TestCycle;
import org.qas.qtest.api.services.execution.model.TestRun;
import org.qas.qtest.api.services.execution.model.TestSuite;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.Release;
import org.qas.qtest.api.services.requirement.model.Requirement;
import org.qas.qtest.api.services.search.model.*;
import org.qas.qtest.api.services.search.transform.*;

/**
 * @author trongle
 * @since 1.4.9
 */
public class SearchServiceClient extends QTestApiWebServiceClient<SearchServiceClient>
  implements SearchService {
  
  public SearchServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
    super(credentials, clientConfiguration);
  }
  
  @Override
  public SearchResult<Release> searchRelease(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.Release);
  }
  
  @Override
  public SearchResult<Build> searchBuild(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.Build);
  }
  
  @Override
  public SearchResult<Requirement> searchRequirement(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.Requirement);
  }
  
  @Override
  public SearchResult<TestCase> searchTestCase(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.TestCase);
  }
  
  @Override
  public SearchResult<TestCycle> searchTestCycle(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.TestCycle);
  }
  
  @Override
  public SearchResult<TestSuite> searchTestSuite(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.TestSuite);
  }
  
  @Override
  public SearchResult<TestRun> searchTestRun(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.TestRun);
  }
  
  @Override
  public SearchResult<Defect> searchDefect(SearchArtifactRequest in) {
    return searchArtifact(in, ArtifactSearchType.Defect);
  }
  
  private SearchResult searchArtifact(SearchArtifactRequest in, ArtifactSearchType searchType) {
    try {
      Request request = new SearchArtifactMarshaller(searchType).marshall(in);
      return invoke(request, new SearchArtifactUnmarshaller(searchType));
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("Failed to search artifact " + searchType.getObjectType().getPath(), ex);
    }
  }
  
  @Override
  public SearchResult<Comment> searchComment(SearchCommentRequest in) {
    try {
      Request request = new SearchCommentMarshaller().marshall(in);
      return invoke(request, new SearchCommentUnmarshaller());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("Failed to search comment for " + in.getObjectType().getPath(), ex);
    }
  }
  
  @Override
  public SearchResult<History> searchHistory(SearchHistoryRequest in) {
    try {
      Request request = new SearchHistoryMarshaller().marshall(in);
      return invoke(request, new SearchHistoryUnmarshaller());
    } catch (Exception ex) {
      Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
      throw new AuthClientException("Failed to search history for " + in.getObjectType().getPath(), ex);
    }
  }
}
