package org.qas.qtest.api.services.search;

import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.defect.model.Defect;
import org.qas.qtest.api.services.design.model.TestCase;
import org.qas.qtest.api.services.execution.model.TestCycle;
import org.qas.qtest.api.services.execution.model.TestRun;
import org.qas.qtest.api.services.execution.model.TestSuite;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.Release;
import org.qas.qtest.api.services.requirement.model.Requirement;
import org.qas.qtest.api.services.search.model.*;

/**
 * @author trongle
 * @since 1.4.9
 */
public interface SearchService extends QTestService {
  SearchResult<Release> searchRelease(SearchArtifactRequest in);
  
  SearchResult<Build> searchBuild(SearchArtifactRequest in);
  
  SearchResult<Requirement> searchRequirement(SearchArtifactRequest in);
  
  SearchResult<TestCase> searchTestCase(SearchArtifactRequest in);
  
  SearchResult<TestCycle> searchTestCycle(SearchArtifactRequest in);
  
  SearchResult<TestSuite> searchTestSuite(SearchArtifactRequest in);
  
  SearchResult<TestRun> searchTestRun(SearchArtifactRequest in);
  
  SearchResult<Defect> searchDefect(SearchArtifactRequest in);
  
  SearchResult<Comment> searchComment(SearchCommentRequest in);
  
  SearchResult<History> searchHistory(SearchHistoryRequest in);
}
