package org.qas.qtest.api.services.requirement;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.services.project.model.GetUserPermissionsRequest;
import org.qas.qtest.api.services.requirement.model.CreateRequirementRequest;
import org.qas.qtest.api.services.requirement.model.GetRequirementFieldsRequest;
import org.qas.qtest.api.services.requirement.model.Requirement;

import java.util.List;

/**
 * RequirementService
 *
 * @author Dzung Nguyen
 * @version $Id RequirementService 2014-05-19 11:33:30z dungvnguyen $
 * @since 1.0
 */
public interface RequirementService extends QTestService {
  /**
   * Gets the requirement fields information.
   *
   * @param getRequirementFieldsRequest the given get requirement field request information.
   * @return the list of requirement field.
   * @throws AuthServiceException if an error occurs during getting the requirement fields.
   * @deprecated replace with {@link org.qas.qtest.api.services.project.ProjectService#getUserPermissions(GetUserPermissionsRequest)}
   */
  @Deprecated
  List<Field> getRequirementFields(GetRequirementFieldsRequest getRequirementFieldsRequest)
      throws AuthServiceException;

  /**
   * Creates the requirement from the given request.
   *
   * @param createRequirementRequest the given {@link CreateRequirementRequest create requirement request}
   *                                 instance that hold the requirement information.
   * @return the requirement object.
   * @throws AuthServiceException if an error occurs during creating requirement.
   */
  Requirement createRequirement(CreateRequirementRequest createRequirementRequest)
      throws AuthServiceException;

  /**
   * Create the requirement comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest create requirement request}
   *                                   instance that hold the requirement request information.
   * @return the requirement information.
   * @throws AuthServiceException if an error occurs during creating requirement comment.
   */
  Requirement addComment(CreateObjectCommentRequest createObjectCommentRequest)
      throws AuthServiceException;
}