package org.qas.qtest.api.services.project.model.transform;

import org.apache.commons.collections.CollectionUtils;
import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.UpdateCustomFieldRequest;
import org.qas.qtest.api.services.project.model.UpdateSystemFieldRequest;

/**
 * UpdateSystemFieldRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UpdateSystemFieldRequestMarshaller 2014-07-11 01:16:30z dungvnguyen $
 * @since 1.0
 */
public final class UpdateCustomFieldRequestMarshaller extends AbstractMarshaller<Request, UpdateCustomFieldRequest> {
  @Override
  protected void validateRequest(UpdateCustomFieldRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }

    if (in.getProjectId() == null
      || in.getProjectId().longValue() == 0) {
      throw new AuthClientException("Invalid project identifier passed to call(...)");
    }

    if (in.getObjectType() == null) {
      throw new AuthClientException("Invalid object type passed to call(...)");
    }

    if (CollectionUtils.isEmpty(in.getFields())) {
      throw new AuthClientException("Invalid fields value passed to call(...)");
    }
  }

  @Override
  protected void build(Request request, UpdateCustomFieldRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "ProjectService";
  }

  @Override
  protected String getActionName() {
    return "UpdateCustomField";
  }

  @Override
  protected String getContent(UpdateCustomFieldRequest in) {
    return JsonMapper.toJson(in.getFields());
  }

  @Override
  protected StringBuilder getResourcePath(UpdateCustomFieldRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId().longValue())
      .append("/settings/")
      .append(in.getObjectType().getPath())
      .append("/custom-fields/active");
    return rpBuilder;
  }
}
