package org.qas.qtest.api.services.project.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.plan.model.Release;
import org.qas.qtest.api.services.project.model.Module;

import java.util.List;

/**
 * ModuleJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ModuleJsonUnmarshaller 2014-05-17 12:16:30z dungvnguyen $
 * @since 1.0
 */
public final class ListReleaseJsonUnmarshaller extends AbstractUnmarshaller<List<Release>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListReleaseJsonUnmarshaller instance;

  //~ class members ===========================================================

  /**
   * @return the {@link ListReleaseJsonUnmarshaller} instance.
   */
  public static ListReleaseJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ListReleaseJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public List<Release> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<Release>>() {
    });
  }
}
