package org.qas.qtest.api.services.project.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.project.model.Module;

import java.util.List;

/**
 * ModuleJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ModuleJsonUnmarshaller 2014-05-17 12:16:30z dungvnguyen $
 * @since 1.0
 */
public final class ListModuleJsonUnmarshaller extends AbstractUnmarshaller<List<Module>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static ListModuleJsonUnmarshaller instance;

  //~ class members ===========================================================

  /**
   * @return the {@link ListModuleJsonUnmarshaller} instance.
   */
  public static ListModuleJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new ListModuleJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public List<Module> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<Module>>() {
    });
  }
}
